/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.retrievers;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.attribute.AttributeLocator;
import org.jboss.arquillian.ajocado.waiting.conversion.Convertor;
import org.jboss.arquillian.ajocado.waiting.conversion.PassOnConvertor;
import org.jboss.arquillian.ajocado.waiting.retrievers.AbstractRetriever;
import org.jboss.arquillian.ajocado.waiting.retrievers.Retriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeRetriever
extends AbstractRetriever<String>
implements Retriever<String> {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private AttributeLocator<?> attributeLocator;

    protected AttributeRetriever() {
    }

    @Override
    public String retrieve() {
        Validate.notNull(this.attributeLocator);
        return this.selenium.getAttribute(this.attributeLocator);
    }

    @Override
    public JavaScript getJavaScriptRetrieve() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.inSeleniumRepresentation());
        return JavaScript.js((String)"selenium.getAttribute('{0}')").parametrize(new Object[]{escapedLocator});
    }

    public static AttributeRetriever getInstance() {
        return new AttributeRetriever();
    }

    public AttributeRetriever attributeLocator(AttributeLocator<?> attributeLocator) {
        Validate.notNull(attributeLocator);
        AttributeRetriever copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    private AttributeRetriever copy() {
        AttributeRetriever copy = new AttributeRetriever();
        copy.attributeLocator = this.attributeLocator;
        return copy;
    }

    @Override
    public Convertor<String, String> getConvertor() {
        return new PassOnConvertor<String>();
    }
}

