/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.browser.Browser;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.ajocado.utils.PrimitiveUtils;

public class SystemPropertiesConfiguration
implements GrapheneConfiguration,
AjocadoConfiguration {
    private static final long serialVersionUID = -660236743676985887L;

    public Browser getBrowser() {
        String browser = System.getProperty("browser", "*firefox");
        Validate.notNull((Object)browser, (String)"browser system property should be set");
        return new Browser(browser);
    }

    public String getSeleniumHost() {
        String seleniumHost = System.getProperty("selenium.host", "localhost");
        Validate.notNull((Object)seleniumHost, (String)"selenium.host system property should be set");
        return seleniumHost;
    }

    public int getSeleniumPort() {
        String seleniumPort = System.getProperty("selenium.port", "4444");
        Validate.notNull((Object)seleniumPort, (String)"selenium.port system property should be set");
        return PrimitiveUtils.asInteger(seleniumPort);
    }

    public boolean isSeleniumMaximize() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.maximize", "false"));
    }

    public boolean isSeleniumDebug() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.debug", "false"));
    }

    public int getSeleniumSpeed() {
        return PrimitiveUtils.asInteger(System.getProperty("selenium.speed", "0"));
    }

    public boolean isSeleniumNetworkTrafficEnabled() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.network.traffic", "false"));
    }

    public long getTimeout(GrapheneConfiguration.TimeoutType type) {
        Validate.notNull((Object)type);
        String seleniumTimeout = System.getProperty("selenium.timeout." + type.toString().toLowerCase());
        if (seleniumTimeout == null) {
            return type.getDefaultTimeout();
        }
        return PrimitiveUtils.asLong(seleniumTimeout);
    }

    public String getStartParameters() {
        return System.getProperty("selenium.start.parameters", null);
    }
}

