/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.cookie;

import java.io.Serializable;
import org.jboss.arquillian.ajocado.selenium.SeleniumRepresentable;

public final class Cookie
implements SeleniumRepresentable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8126558593039344559L;
    private String name;
    private String value;

    private Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static Cookie createCookie(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter can't be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value parameter can't be null");
        }
        return new Cookie(name, value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String inSeleniumRepresentation() {
        return this.name + "=" + this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cookie other = (Cookie)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

