/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.browserstack.extension.local;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.lang3.SystemUtils;
import org.arquillian.drone.browserstack.extension.local.BrowserStackLocalException;
import org.arquillian.drone.browserstack.extension.utils.Utils;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.task.archive.UnzipTool;
import org.arquillian.spacelift.task.net.DownloadTool;

public class BrowserStackLocalRunner {
    private static Logger log = Logger.getLogger(BrowserStackLocalRunner.class.getName());
    private static BrowserStackLocalRunner browserStackLocalRunner = null;
    private final File browserStackLocalDirectory = new File("target" + File.separator + "browserstacklocal");
    private final File browserStackLocalFile = new File(this.browserStackLocalDirectory.getPath() + File.separator + "BrowserStackLocal" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
    private final String basicUrl = "https://www.browserstack.com/browserstack-local/";
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private Process browserStackLocalBinary = null;

    private BrowserStackLocalRunner() {
    }

    public static BrowserStackLocalRunner getBrowserStackLocalInstance() {
        if (browserStackLocalRunner == null) {
            browserStackLocalRunner = new BrowserStackLocalRunner();
        }
        return browserStackLocalRunner;
    }

    public void runBrowserStackLocal(String accessKey, String additionalArgs, String localBinary) throws BrowserStackLocalException {
        if (this.browserStackLocalBinary != null) {
            log.fine("One BrowserStackLocal binary has been already started.");
            return;
        }
        if (Utils.isNullOrEmpty(localBinary)) {
            if (!this.browserStackLocalFile.exists()) {
                this.prepareBrowserStackLocal();
            }
            this.runBrowserStackLocal(this.browserStackLocalFile, accessKey, additionalArgs);
        } else {
            this.runBrowserStackLocal(new File(localBinary), accessKey, additionalArgs);
        }
    }

    private void runBrowserStackLocal(File binaryFile, String accessKey, String additionalArgs) throws BrowserStackLocalException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(binaryFile.getAbsolutePath());
        args.add(accessKey);
        if (!Utils.isNullOrEmpty(additionalArgs)) {
            args.addAll(Arrays.asList(additionalArgs.split(" ")));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(args);
        try {
            this.browserStackLocalBinary = processBuilder.start();
            Reader reader = new Reader();
            reader.start();
            Runtime.getRuntime().addShutdownHook(new ChildProcessCloser());
            this.countDownLatch.await(20L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new BrowserStackLocalException("Running BrowserStackLocal binary unexpectedly failed: ", e);
        }
    }

    private void prepareBrowserStackLocal() {
        String platformBinaryNameUrl = this.getPlatformBinaryNameUrl();
        File browserStackLocalZipFile = new File(this.browserStackLocalDirectory.getPath() + File.separator + platformBinaryNameUrl);
        String url = "https://www.browserstack.com/browserstack-local/" + platformBinaryNameUrl;
        log.info("Creating directory: " + this.browserStackLocalDirectory);
        this.browserStackLocalDirectory.mkdir();
        log.info("downloading zip file from: " + url + " to " + browserStackLocalZipFile.getPath());
        ((DownloadTool)Spacelift.task(DownloadTool.class)).from(url).to(browserStackLocalZipFile.getPath()).execute().await();
        log.info("extracting zip file: " + browserStackLocalZipFile + " to " + this.browserStackLocalDirectory.getPath());
        ((UnzipTool)Spacelift.task((Object)browserStackLocalZipFile, UnzipTool.class)).toDir(this.browserStackLocalDirectory.getPath()).execute().await();
        log.info("marking binary file: " + this.browserStackLocalFile.getPath() + " as executable");
        try {
            this.browserStackLocalFile.setExecutable(true);
        }
        catch (SecurityException se) {
            log.severe("The downloaded BrowserStackLocal binary: " + this.browserStackLocalFile + " could not be set as executable. This may cause additional problems.");
        }
    }

    private String getPlatformBinaryNameUrl() {
        String binary = "BrowserStackLocal-%s.zip";
        if (SystemUtils.IS_OS_WINDOWS) {
            return String.format(binary, "win32");
        }
        if (SystemUtils.IS_OS_UNIX) {
            if (Utils.is64()) {
                return String.format(binary, "linux-x64");
            }
            return String.format(binary, "linux-ia32");
        }
        if (SystemUtils.IS_OS_MAC) {
            return String.format(binary, "darwin-x64");
        }
        throw new IllegalStateException("The current platform is not supported.Supported platforms are windows, linux and macosx.Your platform has been detected as " + SystemUtils.OS_NAME);
    }

    private class ChildProcessCloser
    extends Thread {
        private ChildProcessCloser() {
        }

        @Override
        public void run() {
            BrowserStackLocalRunner.this.browserStackLocalBinary.destroy();
            try {
                BrowserStackLocalRunner.this.browserStackLocalBinary.waitFor();
            }
            catch (InterruptedException e) {
                throw new BrowserStackLocalException("Stopping BrowserStackLocal binary unexpectedly failed: ", e);
            }
        }
    }

    private class ProcessEndChecker
    implements Callable<Boolean> {
        private ProcessEndChecker() {
        }

        @Override
        public Boolean call() throws Exception {
            BrowserStackLocalRunner.this.browserStackLocalBinary.waitFor();
            return true;
        }
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(BrowserStackLocalRunner.this.browserStackLocalBinary.getInputStream()));
            boolean isAlreadyRunning = false;
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new ProcessEndChecker());
            Executors.newSingleThreadExecutor().submit(futureTask);
            while (!isAlreadyRunning) {
                try {
                    Process process = BrowserStackLocalRunner.this.browserStackLocalBinary;
                    synchronized (process) {
                        String line;
                        if (futureTask.isDone()) {
                            break;
                        }
                        while (in.ready() && (line = in.readLine()) != null) {
                            System.out.println("[BrowserStackLocal]$ " + line);
                            if (BrowserStackLocalRunner.this.countDownLatch.getCount() <= 0L) continue;
                            if (line.contains("You can now access your local server(s) in our remote browser.")) {
                                BrowserStackLocalRunner.this.countDownLatch.countDown();
                                continue;
                            }
                            if (!line.contains("Either another browserstack local client is running on your machine or some server is listening on port")) continue;
                            isAlreadyRunning = true;
                            BrowserStackLocalRunner.this.countDownLatch.countDown();
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    throw new BrowserStackLocalException("Reading BrowserStackLocal binary output unexpectedly failed: ", e);
                }
            }
        }
    }
}

