/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.angular.findby;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.List;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.graphene.spi.ImplementedBy;
import org.jboss.arquillian.graphene.spi.TypeResolver;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByAngular
extends By {
    protected By implementation;

    protected By instantiate(Class<? extends By> type, String lookup) {
        try {
            Class clazz = TypeResolver.resolveType(type);
            Constructor constructor = clazz.getConstructor(String.class);
            return (By)constructor.newInstance(lookup);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate " + type, e);
        }
    }

    public WebElement findElement(SearchContext context) {
        return this.implementation.findElement(context);
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.implementation.findElements(context);
    }

    public String toString() {
        return this.implementation.toString();
    }

    public static By model(String modelName) {
        Validate.notNull((Object)modelName, (String)"Cannot find element when ng-model name is null!");
        return new ByModel(modelName);
    }

    public static By action(String action) {
        Validate.notNull((Object)action, (String)"Cannot find element when action is null!");
        return new ByAction(action);
    }

    public static By repeat(String repeaterText) {
        Validate.notNull((Object)repeaterText, (String)"Cannot find element when repeater text is null!");
        return new ByRepeat(repeaterText);
    }

    @ImplementedBy(className="org.jboss.arquillian.graphene.angular.findby.ByRepeatImpl")
    public static class ByRepeat
    extends ByAngular
    implements Serializable {
        public ByRepeat(String repeaterText) {
            this.implementation = this.instantiate(ByRepeat.class, repeaterText);
        }
    }

    @ImplementedBy(className="org.jboss.arquillian.graphene.angular.findby.ByActionImpl")
    public static class ByAction
    extends ByAngular
    implements Serializable {
        public ByAction(String action) {
            this.implementation = this.instantiate(ByAction.class, action);
        }
    }

    @ImplementedBy(className="org.jboss.arquillian.graphene.angular.findby.ByModelImpl")
    public static class ByModel
    extends ByAngular
    implements Serializable {
        public ByModel(String modelName) {
            this.implementation = this.instantiate(ByModel.class, modelName);
        }
    }
}

