/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.embedded_6;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.ExpandWar;
import org.jboss.arquillian.container.tomcat.embedded_6.EmbeddedContextConfig;
import org.jboss.arquillian.container.tomcat.embedded_6.TomcatConfiguration;
import org.jboss.arquillian.protocol.servlet_3.ServletMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.tomcat_6.api.ShrinkWrapStandardContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatContainer
implements DeployableContainer {
    private static final Logger log = Logger.getLogger(TomcatContainer.class.getName());
    private static final String ENV_VAR = "${env.";
    private static final String HTTP_PROTOCOL = "http";
    private static final String TMPDIR_SYS_PROP = "java.io.tmpdir";
    private Embedded embedded;
    private Engine engine;
    private Host standardHost;
    private TomcatConfiguration configuration;
    private String serverName;
    private String bindAddress;
    private int bindPort;
    private boolean wasStarted;
    private final List<String> failedUndeployments = new ArrayList<String>();

    public void setup(Context context, Configuration configuration) {
        this.configuration = (TomcatConfiguration)configuration.getContainerConfig(TomcatConfiguration.class);
        this.bindAddress = this.configuration.getBindAddress();
        this.bindPort = this.configuration.getBindHttpPort();
        this.serverName = this.configuration.getServerName();
    }

    public void start(Context context) throws org.jboss.arquillian.spi.LifecycleException {
        try {
            this.startTomcatEmbedded();
        }
        catch (Exception e) {
            throw new org.jboss.arquillian.spi.LifecycleException("Bad shit happened", (Throwable)e);
        }
    }

    public void stop(Context context) throws org.jboss.arquillian.spi.LifecycleException {
        try {
            this.removeFailedUnDeployments();
        }
        catch (Exception e) {
            throw new org.jboss.arquillian.spi.LifecycleException("Could not clean up", (Throwable)e);
        }
        if (this.wasStarted) {
            try {
                this.stopTomcatEmbedded();
            }
            catch (LifecycleException e) {
                throw new org.jboss.arquillian.spi.LifecycleException("An unexpected error occurred", (Throwable)e);
            }
        }
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        if (this.embedded == null) {
            throw new IllegalStateException("Embedded container is not running");
        }
        try {
            StandardContext standardContext = (StandardContext)archive.as(ShrinkWrapStandardContext.class);
            standardContext.addLifecycleListener((LifecycleListener)new EmbeddedContextConfig());
            standardContext.setUnpackWAR(this.configuration.isUnpackArchive());
            if (standardContext.getUnpackWAR()) {
                this.deleteUnpackedWAR(standardContext);
            }
            this.standardHost.addChild((Container)standardContext);
            context.add(StandardContext.class, (Object)standardContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to deploy " + archive.getName(), (Throwable)e);
        }
        try {
            return new ServletMethodExecutor(new URL(HTTP_PROTOCOL, this.bindAddress, this.bindPort, "/"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create ContainerMethodExecutor", e);
        }
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        StandardContext standardContext = (StandardContext)context.get(StandardContext.class);
        if (standardContext != null) {
            this.standardHost.removeChild((Container)standardContext);
            if (standardContext.getUnpackWAR()) {
                this.deleteUnpackedWAR(standardContext);
            }
        }
    }

    private void undeploy(String name) throws DeploymentException {
        Container child = this.standardHost.findChild(name);
        if (child != null) {
            this.standardHost.removeChild(child);
        }
    }

    private void removeFailedUnDeployments() throws IOException {
        ArrayList remainingDeployments = new ArrayList();
        for (String name : this.failedUndeployments) {
            try {
                this.undeploy(name);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (remainingDeployments.size() > 0) {
            log.severe("Failed to undeploy these artifacts: " + remainingDeployments);
        }
        this.failedUndeployments.clear();
    }

    protected void startTomcatEmbedded() throws UnknownHostException, LifecycleException {
        this.embedded = new Embedded();
        this.embedded.setName(this.serverName);
        String tomcatHome = this.configuration.getTomcatHome();
        File tomcatHomeFile = null;
        if (tomcatHome != null) {
            if (tomcatHome.startsWith(ENV_VAR)) {
                String sysVar = tomcatHome.substring(ENV_VAR.length(), tomcatHome.length() - 1);
                if ((tomcatHome = System.getProperty(sysVar)) != null && tomcatHome.length() > 0 && new File(tomcatHome).isAbsolute()) {
                    tomcatHomeFile = new File(tomcatHome);
                    log.info("Using tomcat home from environment variable: " + tomcatHome);
                }
            } else {
                tomcatHomeFile = new File(tomcatHome);
            }
        }
        if (tomcatHomeFile == null) {
            tomcatHomeFile = new File(System.getProperty(TMPDIR_SYS_PROP), "tomcat-embedded-6");
        }
        tomcatHomeFile.mkdirs();
        this.embedded.setCatalinaBase(tomcatHomeFile.getAbsolutePath());
        this.embedded.setCatalinaHome(tomcatHomeFile.getAbsolutePath());
        this.engine = this.embedded.createEngine();
        this.engine.setName(this.serverName);
        this.engine.setDefaultHost(this.bindAddress);
        this.engine.setService((Service)this.embedded);
        this.embedded.setContainer((Container)this.engine);
        this.embedded.addEngine(this.engine);
        File appBaseFile = new File(tomcatHomeFile, this.configuration.getAppBase());
        appBaseFile.mkdirs();
        this.standardHost = this.embedded.createHost(this.bindAddress, appBaseFile.getAbsolutePath());
        if (this.configuration.getTomcatWorkDir() != null) {
            ((StandardHost)this.standardHost).setWorkDir(this.configuration.getTomcatWorkDir());
        }
        ((StandardHost)this.standardHost).setUnpackWARs(this.configuration.isUnpackArchive());
        this.engine.addChild((Container)this.standardHost);
        Connector connector = this.embedded.createConnector(InetAddress.getByName(this.bindAddress), this.bindPort, false);
        this.embedded.addConnector(connector);
        connector.setContainer((Container)this.engine);
        this.embedded.init();
        this.embedded.start();
        this.wasStarted = true;
    }

    protected void stopTomcatEmbedded() throws org.jboss.arquillian.spi.LifecycleException, LifecycleException {
        this.embedded.stop();
    }

    protected void deleteUnpackedWAR(StandardContext standardContext) {
        File unpackDir = new File(this.standardHost.getAppBase(), standardContext.getPath().substring(1));
        if (unpackDir.exists()) {
            ExpandWar.deleteDir((File)unpackDir);
        }
    }
}

