/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openwebbeans.embedded_1;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import org.apache.webbeans.corespi.scanner.AbstractMetaDataDiscovery;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkWrapMetaDataDiscovery
extends AbstractMetaDataDiscovery {
    private Archive<?> archive;

    public ShrinkWrapMetaDataDiscovery(Archive<?> archive) {
        this.archive = archive;
    }

    protected void configure() throws Exception {
        Map beansXmls = this.archive.getContent(Filters.include((String)"/META-INF/beans.xml"));
        boolean beansXmlPresent = false;
        for (final Map.Entry entry : beansXmls.entrySet()) {
            try {
                this.addWebBeansXmlLocation(new URL(null, "archive:/" + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            public void connect() throws IOException {
                            }

                            public InputStream getInputStream() throws IOException {
                                return ((Node)entry.getValue()).getAsset().openStream();
                            }
                        };
                    }
                }));
                beansXmlPresent = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (beansXmlPresent) {
            Map classes = this.archive.getContent(Filters.include((String)".*\\.class"));
            for (Map.Entry classEntry : classes.entrySet()) {
                try {
                    this.getAnnotationDB().scanClass(((Node)classEntry.getValue()).getAsset().openStream());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not scan class", e);
                }
            }
        }
    }
}

