/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openwebbeans.embedded_1;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkWrapClassLoader
extends SecureClassLoader {
    public static final String ARCHIVE_PROTOCOL = "archive:/";
    private final Archive<?> archive;

    public ShrinkWrapClassLoader(Archive<?> archive) {
        this.archive = archive;
    }

    @Override
    protected URL findResource(String name) {
        final Node a = this.archive.get(name);
        if (a == null) {
            return null;
        }
        try {
            return new URL(null, ARCHIVE_PROTOCOL + name, new URLStreamHandler(){

                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        public void connect() throws IOException {
                        }

                        public InputStream getInputStream() throws IOException {
                            return a.getAsset().openStream();
                        }
                    };
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Iterator<Object> it = new ArrayList(0).iterator();
        URL resource = this.findResource(name);
        if (resource != null) {
            it = Arrays.asList(resource).iterator();
        }
        final Iterator i = it;
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)i.next();
            }
        };
    }
}

