/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openwebbeans.embedded_1;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.lifecycle.StandaloneLifeCycle;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.jboss.arquillian.container.openwebbeans.embedded_1.ShrinkWrapClassLoader;
import org.jboss.arquillian.container.openwebbeans.embedded_1.ShrinkWrapMetaDataDiscovery;
import org.jboss.arquillian.protocol.local.LocalMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenWebBeansSEContainer
implements DeployableContainer {
    private static final Logger log = Logger.getLogger(OpenWebBeansSEContainer.class.getName());
    public static final ThreadLocal<ContainerInstanceHolder> CONTAINER_INSTANCE_HOLDER = new ThreadLocal();

    public void setup(Context context, Configuration configuration) {
    }

    public void start(Context context) throws LifecycleException {
    }

    public void stop(Context context) throws LifecycleException {
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        ShrinkWrapClassLoader cl = new ShrinkWrapClassLoader(archive);
        Thread.currentThread().setContextClassLoader(cl);
        final ShrinkWrapMetaDataDiscovery discovery = new ShrinkWrapMetaDataDiscovery(archive);
        StandaloneLifeCycle lifecycle = new StandaloneLifeCycle(){

            public void init() {
                super.init();
                log.info("Using discovery service impl class adapted to ShrinkWrap archive : [" + ((Object)((Object)discovery)).getClass().getName() + "]");
                this.discoveryService = discovery;
            }
        };
        try {
            lifecycle.start(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start standalone OpenWebBeans container", e);
        }
        BeanManager manager = lifecycle.getBeanManager();
        ContextFactory.initApplicationContext(null);
        MockHttpSession session = new MockHttpSession();
        ContextFactory.initSessionContext((HttpSession)session);
        CONTAINER_INSTANCE_HOLDER.set(new ContainerInstanceHolder((ContainerLifecycle)lifecycle, session, manager));
        return new LocalMethodExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TestResult invoke(TestMethodExecutor testMethodExecutor) {
                try {
                    ContextFactory.initRequestContext(null);
                    ContextFactory.initConversationContext(null);
                    TestResult testResult = super.invoke(testMethodExecutor);
                    return testResult;
                }
                finally {
                    ContextFactory.destroyConversationContext();
                    ContextFactory.destroyRequestContext(null);
                }
            }
        };
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        ContainerInstanceHolder holder = CONTAINER_INSTANCE_HOLDER.get();
        if (holder != null) {
            ContextFactory.destroySessionContext((HttpSession)holder.getSession());
            ContextFactory.destroyApplicationContext(null);
            holder.getLifecycle().stop(null);
            Thread.currentThread().setContextClassLoader(Thread.currentThread().getContextClassLoader().getParent());
        }
        CONTAINER_INSTANCE_HOLDER.set(null);
    }

    private class MockHttpSession
    implements HttpSession {
        private final long creationTime = System.currentTimeMillis();
        private final String id = UUID.randomUUID().toString();
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private int maxInactiveInterval = 60000;

        public long getCreationTime() {
            return this.creationTime;
        }

        public String getId() {
            return this.id;
        }

        public long getLastAccessedTime() {
            return this.creationTime;
        }

        public ServletContext getServletContext() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void setMaxInactiveInterval(int i) {
            this.maxInactiveInterval = i;
        }

        public int getMaxInactiveInterval() {
            return this.maxInactiveInterval;
        }

        public HttpSessionContext getSessionContext() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Object getAttribute(String string) {
            return this.attributes.get(string);
        }

        public Object getValue(String string) {
            return this.getAttribute(string);
        }

        public Enumeration getAttributeNames() {
            final Iterator<String> nameIt = this.attributes.keySet().iterator();
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return nameIt.hasNext();
                }

                public Object nextElement() {
                    return nameIt.next();
                }
            };
        }

        public String[] getValueNames() {
            return this.attributes.keySet().toArray(new String[0]);
        }

        public void setAttribute(String string, Object value) {
            this.attributes.put(string, value);
        }

        public void putValue(String string, Object value) {
            this.setAttribute(string, value);
        }

        public void removeAttribute(String string) {
            this.attributes.remove(string);
        }

        public void removeValue(String string) {
            this.removeAttribute(string);
        }

        public void invalidate() {
            this.attributes.clear();
        }

        public boolean isNew() {
            return true;
        }
    }

    public static class ContainerInstanceHolder {
        private BeanManager manager;
        private ContainerLifecycle lifecycle;
        private HttpSession session;

        public ContainerInstanceHolder(ContainerLifecycle lifecycle, HttpSession session, BeanManager manager) {
            this.lifecycle = lifecycle;
            this.session = session;
            this.manager = manager;
        }

        public ContainerLifecycle getLifecycle() {
            return this.lifecycle;
        }

        public HttpSession getSession() {
            return this.session;
        }

        public BeanManager getManager() {
            return this.manager;
        }
    }
}

