/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.prototyping.context.impl.openejb;

import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.arquillian.prototyping.context.impl.BaseContextualResolver;
import org.jboss.arquillian.prototyping.context.spi.ContextualResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBJndiContextResolver
extends BaseContextualResolver
implements ContextualResolver {
    private static final OpenEJBJndiContextResolver INSTANCE = new OpenEJBJndiContextResolver();
    private static final String PROP_VALUE_OPENEJB_INITIAL_CONTEXT_FACTORY = "org.apache.openejb.client.LocalInitialContextFactory";

    private OpenEJBJndiContextResolver() {
    }

    public static OpenEJBJndiContextResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> T resolve(Class<T> type, Map<String, Object> properties) throws IllegalArgumentException {
        if (Context.class.isAssignableFrom(type)) {
            return type.cast(this.createJndiContext(properties));
        }
        return null;
    }

    private Context createJndiContext(Map<String, Object> properties) {
        Properties propsUsedInContextCreation = new Properties();
        propsUsedInContextCreation.put("java.naming.factory.initial", PROP_VALUE_OPENEJB_INITIAL_CONTEXT_FACTORY);
        propsUsedInContextCreation.putAll(properties);
        try {
            return new InitialContext(propsUsedInContextCreation);
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not create new JNDI Context", e);
        }
    }
}

