/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openejb.embedded_3_1;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.inject.Inject;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import org.apache.openejb.assembler.classic.AppInfo;
import org.jboss.arquillian.prototyping.context.api.ArquillianContext;
import org.jboss.arquillian.prototyping.context.api.Properties;
import org.jboss.arquillian.prototyping.context.api.Property;
import org.jboss.arquillian.prototyping.context.impl.PropertiesImpl;
import org.jboss.arquillian.prototyping.context.impl.openejb.OpenEJBArquillianContextImpl;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.testenricher.ejb.EJBInjectionEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBTestEnricher
extends EJBInjectionEnricher {
    private ArquillianContext arquillianContext = null;

    public void enrich(Context context, Object testCase) {
        super.enrich(context, testCase);
        Class<Inject> inject = Inject.class;
        List fieldsWithInject = this.getFieldsWithAnnotation(testCase.getClass(), inject);
        for (final Field field : fieldsWithInject) {
            if (!field.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
            }
            try {
                Object resolvedVaue;
                ArquillianContext arquillianContext = this.getArquillianContext(context);
                Class<?> type = field.getType();
                if (field.isAnnotationPresent(Properties.class)) {
                    Properties properties = field.getAnnotation(Properties.class);
                    resolvedVaue = arquillianContext.get(type, properties);
                } else if (field.isAnnotationPresent(Property.class)) {
                    Property property = field.getAnnotation(Property.class);
                    PropertiesImpl properties = new PropertiesImpl(new Property[]{property});
                    resolvedVaue = arquillianContext.get(type, properties);
                } else {
                    resolvedVaue = arquillianContext.get(type);
                }
                field.set(testCase, resolvedVaue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not inject into " + field.getName() + " of test case: " + testCase, e);
            }
        }
    }

    protected ArquillianContext getArquillianContext(Context context) {
        if (this.arquillianContext == null) {
            AppInfo deployment = (AppInfo)context.get(AppInfo.class);
            this.arquillianContext = new OpenEJBArquillianContextImpl(deployment);
        }
        return this.arquillianContext;
    }

    protected InitialContext createContext(Context context) throws Exception {
        return this.getArquillianContext(context).get(InitialContext.class);
    }

    protected Object lookupEJB(Context context, Class<?> fieldType) throws Exception {
        InitialContext initcontext = this.createContext(context);
        return this.lookupRecursive(fieldType, initcontext, initcontext.listBindings("/"));
    }

    protected Object lookupRecursive(Class<?> fieldType, javax.naming.Context context, NamingEnumeration<Binding> contextNames) throws Exception {
        while (contextNames.hasMore()) {
            Binding contextName = (Binding)contextNames.nextElement();
            Object value = contextName.getObject();
            if (javax.naming.Context.class.isInstance(value)) {
                javax.naming.Context subContext = (javax.naming.Context)value;
                return this.lookupRecursive(fieldType, subContext, subContext.listBindings("/"));
            }
            value = context.lookup(contextName.getName());
            if (!fieldType.isInstance(value)) continue;
            return value;
        }
        throw new RuntimeException("Could not lookup EJB reference for: " + fieldType);
    }
}

