/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.embedded;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.logging.Logger;
import org.jboss.arquillian.container.appengine.embedded.hack.AppEngineHack;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

class AppEngineSetup {
    private static Logger log = Logger.getLogger(AppEngineSetup.class.getName());
    private static final String LOCAL_MAVEN_REPO = System.getProperty("user.home") + File.separatorChar + ".m2" + File.separatorChar + "repository";
    private static final String GROUP_ID = "com.google.appengine";
    private static final String VERSION = "1.3.7";
    private static final String[] FILES = new String[]{"appengine-api-1.0-sdk"};

    AppEngineSetup() {
    }

    static void addToJavaExtDirs(String className) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            AppEngineSetup.addToJavaExtDirs(cl.loadClass(className));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void addToJavaExtDirs(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        ProtectionDomain domain = clazz.getProtectionDomain();
        CodeSource source = domain.getCodeSource();
        URL location = source.getLocation();
        String addon = location.getPath();
        String ext = System.getProperty("java.ext.dirs");
        if (ext == null) {
            System.setProperty("java.ext.dirs", addon);
        } else {
            System.setProperty("java.ext.dirs", ext + File.pathSeparator + addon);
        }
    }

    static void prepare(Archive archive) {
        File[] files = AppEngineSetup.getFiles();
        WebArchive webArchive = (WebArchive)archive.as(WebArchive.class);
        webArchive.addAsLibraries(files);
        webArchive.addClass(AppEngineHack.class);
        log.info(webArchive.toString(true));
    }

    private static File[] getFiles() {
        File[] files = new File[FILES.length];
        for (int i = 0; i < files.length; ++i) {
            File file = AppEngineSetup.resolve(GROUP_ID, FILES[i], VERSION);
            if (!file.exists()) {
                throw new IllegalArgumentException("Missing AppEngine library: " + file);
            }
            files[i] = file;
        }
        return files;
    }

    private static File resolve(String groupId, String artifactId, String version) {
        return new File(LOCAL_MAVEN_REPO + File.separatorChar + groupId.replace(".", File.separator) + File.separatorChar + artifactId + File.separatorChar + version + File.separatorChar + artifactId + "-" + version + ".jar");
    }
}

