/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.descriptor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.config.descriptor.impl.ArquillianDescriptorImpl;
import org.jboss.arquillian.config.descriptor.impl.ProtocolDefImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerDefImpl
extends ArquillianDescriptorImpl
implements ContainerDef {
    private Node container;

    public ContainerDefImpl(String descirptorName) {
        this(descirptorName, new Node("arquillian"));
    }

    public ContainerDefImpl(String descirptorName, Node model) {
        this(descirptorName, model, model.createChild("container"));
    }

    public ContainerDefImpl(String descirptorName, Node model, Node container) {
        super(descirptorName, model);
        this.container = container;
    }

    public ContainerDef setContainerName(String name) {
        this.container.attribute("qualifier", name);
        return this;
    }

    public String getContainerName() {
        return this.container.getAttribute("qualifier");
    }

    public ContainerDef setDefault() {
        this.container.attribute("default", (Object)true);
        return this;
    }

    public boolean isDefault() {
        return Boolean.parseBoolean(this.container.getAttribute("default"));
    }

    public ContainerDef dependency(String artifactId) {
        this.container.getOrCreate("dependencies").getOrCreate("dependency=" + artifactId);
        return this;
    }

    public ProtocolDef protocol(String type) {
        return new ProtocolDefImpl(this.getDescriptorName(), this.getRootNode(), this.container, this.container.getOrCreate("protocol@type=" + type));
    }

    public ContainerDef property(String name, String value) {
        this.container.getOrCreate("configuration").getOrCreate("property@name=" + name).text(value);
        return this;
    }

    public Map<String, String> getContainerProperties() {
        Node props = this.container.getSingle("configuration");
        HashMap<String, String> properties = new HashMap<String, String>();
        if (props != null) {
            for (Node prop : props.get("property")) {
                properties.put(prop.getAttribute("name"), prop.getText());
            }
        }
        return properties;
    }

    public List<ProtocolDef> getProtocols() {
        ArrayList<ProtocolDef> protocols = new ArrayList<ProtocolDef>();
        for (Node proto : this.container.get("protocol")) {
            protocols.add(new ProtocolDefImpl(this.getDescriptorName(), this.getRootNode(), this.container, proto));
        }
        return protocols;
    }

    public List<String> getDependencies() {
        ArrayList<String> dependencies = new ArrayList<String>();
        if (this.container.getSingle("dependencies") != null) {
            for (Node dep : this.container.getSingle("dependencies").get("dependency")) {
                dependencies.add(dep.getText());
            }
        }
        return dependencies;
    }

    public String toString() {
        return this.container.toString(true);
    }
}

