/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.util;

import org.jboss.arquillian.spi.TestRunner;
import org.jboss.arquillian.spi.util.ServiceLoader;
import org.jboss.arquillian.spi.util.TCCLActions;

public final class TestRunners {
    private TestRunners() {
    }

    public static TestRunner getTestRunner() {
        return TestRunners.getTestRunner(TCCLActions.getClassLoader());
    }

    public static TestRunner getTestRunner(ClassLoader classLoader) {
        ServiceLoader<TestRunner> serviceLoader = ServiceLoader.load(TestRunner.class, classLoader);
        if (serviceLoader.getProviders().size() == 0) {
            throw new IllegalStateException("Cannot load TestRunner from: " + classLoader);
        }
        if (serviceLoader.getProviders().size() > 1) {
            throw new IllegalStateException("Multiple TestRunners found: " + classLoader);
        }
        return serviceLoader.iterator().next();
    }
}

