/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.ConstructorMatcher;
import org.jboss.aop.pointcut.FieldMatcher;
import org.jboss.aop.pointcut.MethodMatcher;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAnd;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTBoolean;
import org.jboss.aop.pointcut.ast.ASTClass;
import org.jboss.aop.pointcut.ast.ASTComposite;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTNot;
import org.jboss.aop.pointcut.ast.ASTOr;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTSub;
import org.jboss.aop.pointcut.ast.Node;
import org.jboss.aop.pointcut.ast.SimpleNode;
import org.jboss.aop.pointcut.ast.TypeExpressionParserVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMatcher
implements TypeExpressionParserVisitor {
    private Advisor advisor;
    private Object element;

    public AnnotationMatcher(Advisor advisor, Object element) {
        this.advisor = advisor;
        this.element = element;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    @Override
    public Object visit(ASTBoolean node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    @Override
    public Object visit(ASTComposite node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    @Override
    public Object visit(ASTNot node, Object data) {
        Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        boolean val = bool;
        return val ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public Object visit(ASTSub node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            data = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTAnd node, Object left) {
        Node andChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val && (Boolean)andChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    @Override
    public Object visit(ASTOr node, Object left) {
        Node orChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val || (Boolean)orChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public CtClass getDeclaringClass() {
        if (this.element instanceof CtClass) {
            return (CtClass)this.element;
        }
        if (this.element instanceof CtMethod) {
            return ((CtMethod)this.element).getDeclaringClass();
        }
        if (this.element instanceof CtField) {
            return ((CtField)this.element).getDeclaringClass();
        }
        if (this.element instanceof CtConstructor) {
            return ((CtConstructor)this.element).getDeclaringClass();
        }
        return null;
    }

    public Class<?> getJavaDeclaringClass() {
        if (this.element instanceof Class) {
            return (Class)this.element;
        }
        if (this.element instanceof Method) {
            return ((Method)this.element).getDeclaringClass();
        }
        if (this.element instanceof Field) {
            return ((Field)this.element).getDeclaringClass();
        }
        if (this.element instanceof Constructor) {
            return ((Constructor)this.element).getDeclaringClass();
        }
        return null;
    }

    @Override
    public Object visit(ASTHas node, Object data) {
        Node n = node.jjtGetChild(0);
        if (this.getDeclaringClass() != null) {
            CtClass clazz = this.getDeclaringClass();
            if (n instanceof ASTMethod) {
                return new Boolean(Util.has(clazz, (ASTMethod)n, this.advisor));
            }
            return new Boolean(Util.has(clazz, (ASTConstructor)n, this.advisor));
        }
        Class<?> clazz = this.getJavaDeclaringClass();
        if (n instanceof ASTMethod) {
            return new Boolean(Util.has(clazz, (ASTMethod)n, this.advisor));
        }
        return new Boolean(Util.has(clazz, (ASTConstructor)n, this.advisor));
    }

    @Override
    public Object visit(ASTHasField node, Object data) {
        if (this.getDeclaringClass() != null) {
            CtClass clazz = this.getDeclaringClass();
            ASTField f = (ASTField)node.jjtGetChild(0);
            return new Boolean(Util.has(clazz, f, this.advisor));
        }
        Class<?> clazz = this.getJavaDeclaringClass();
        ASTField f = (ASTField)node.jjtGetChild(0);
        return new Boolean(Util.has(clazz, f, this.advisor));
    }

    @Override
    public Object visit(ASTClass node, Object data) {
        if (!(this.element instanceof CtClass) && !(this.element instanceof Class)) {
            return Boolean.FALSE;
        }
        if (this.element instanceof CtClass) {
            CtClass clazz = (CtClass)this.element;
            return new Boolean(Util.matchesClassExpr(node.getClazz(), clazz, this.advisor));
        }
        Class clazz = (Class)this.element;
        return new Boolean(Util.matchesClassExpr(node.getClazz(), clazz, this.advisor));
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!(this.element instanceof CtMethod) && !(this.element instanceof Method)) {
            return Boolean.FALSE;
        }
        if (this.element instanceof CtMethod) {
            MethodMatcher methodMatcher = null;
            methodMatcher = new MethodMatcher(this.advisor, (CtMethod)this.element, null);
            return methodMatcher.matches(node);
        }
        MethodMatcher methodMatcher = null;
        methodMatcher = new MethodMatcher(this.advisor, (Method)this.element, null);
        return methodMatcher.matches(node);
    }

    @Override
    public Object visit(ASTConstructor node, Object data) {
        if (!(this.element instanceof CtConstructor) && !(this.element instanceof Constructor)) {
            return Boolean.FALSE;
        }
        if (this.element instanceof CtConstructor) {
            ConstructorMatcher conMatcher = null;
            try {
                conMatcher = new ConstructorMatcher(this.advisor, (CtConstructor)this.element, null);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            return conMatcher.matches(node);
        }
        ConstructorMatcher conMatcher = null;
        conMatcher = new ConstructorMatcher(this.advisor, (Constructor)this.element, null);
        return conMatcher.matches(node);
    }

    @Override
    public Object visit(ASTField node, Object data) {
        if (!(this.element instanceof CtField) && !(this.element instanceof Field)) {
            return Boolean.FALSE;
        }
        if (this.element instanceof CtField) {
            FieldMatcher fieldMatcher = null;
            try {
                fieldMatcher = new FieldMatcher(this.advisor, (CtField)this.element, null);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            return node.jjtAccept(fieldMatcher, null);
        }
        FieldMatcher fieldMatcher = null;
        fieldMatcher = new FieldMatcher(this.advisor, (Field)this.element, null);
        return node.jjtAccept(fieldMatcher, null);
    }

    @Override
    public Object visit(ASTAttribute node, Object data) {
        return Boolean.FALSE;
    }

    @Override
    public Object visit(ASTParameter node, Object data) {
        return Boolean.FALSE;
    }

    @Override
    public Object visit(ASTAllParameter node, Object data) {
        return Boolean.FALSE;
    }

    @Override
    public Object visit(ASTException node, Object data) {
        return Boolean.FALSE;
    }
}

