/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.lang.reflect.Constructor;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.ContainerProxyFactory;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedAOPProxyFactory
implements AOPProxyFactory {
    private static final Logger logger = AOPLogger.getLogger(GeneratedAOPProxyFactory.class);

    public static <T> T createProxy(T target, Class<T> interfaceClass) {
        if (target == null) {
            return null;
        }
        GeneratedAOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setInterfaces(new Class[]{interfaceClass});
        params.setObjectAsSuperClass(true);
        params.setTarget(target);
        Object proxy = proxyFactory.createAdvisedProxy(params);
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("Created proxy: " + proxy.getClass() + "@" + System.identityHashCode(proxy) + " target: " + target.getClass()));
        }
        return interfaceClass.cast(proxy);
    }

    @Override
    public Object createAdvisedProxy(AOPProxyFactoryParameters params) {
        if (params.getTarget() != null) {
            if (params.getProxiedClass() != null) {
                if (!params.getProxiedClass().isAssignableFrom(params.getTarget().getClass())) {
                    throw new RuntimeException("Specified class type " + params.getProxiedClass().getName() + " and target " + params.getTarget().getClass().getName() + " are not compatible");
                }
            } else {
                params.setProxiedClass(params.getTarget().getClass());
            }
        } else if (params.getProxiedClass() == null) {
            params.setProxiedClass(Object.class);
        }
        return this.getProxy(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getProxy(AOPProxyFactoryParameters params) {
        try {
            Class proxyClass = null;
            boolean isAdvised = Advised.class.isAssignableFrom(params.getProxiedClass());
            if (params.getTarget() instanceof Untransformable || isAdvised && params.getInterfaces() == null && params.getMixins() == null && (params.getMetaData() == null || !params.getMetaDataHasInstanceLevelData()) && params.getSimpleMetaData() == null) {
                return params.getTarget();
            }
            Object object = ContainerCache.mapLock;
            synchronized (object) {
                if (params.getContainerCache() == null) {
                    params.setContainerCache(ContainerCache.initialise(AspectManager.instance(), params));
                }
                if (!params.getContainerCache().hasAspects() && !params.getContainerCache().requiresInstanceAdvisor()) {
                    return params.getTarget();
                }
                proxyClass = this.generateProxy(params);
            }
            return this.instantiateAndConfigureProxy(proxyClass, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class generateProxy(AOPProxyFactoryParameters params) throws Exception {
        Class proxyClass = ContainerProxyFactory.getProxyClass(params.isObjectAsSuperClass(), params.getContainerCache().getKey(), params.getContainerCache().getAdvisor());
        return proxyClass;
    }

    private Object instantiateAndConfigureProxy(Class proxyClass, AOPProxyFactoryParameters params) throws Exception {
        AspectManaged proxy;
        if (params.getCtor() != null) {
            Constructor ctor = proxyClass.getConstructor(params.getCtor().getSignature());
            proxy = (AspectManaged)ctor.newInstance(params.getCtor().getArguments());
        } else {
            proxy = (AspectManaged)proxyClass.newInstance();
        }
        proxy.setAdvisor(params.getContainerCache().getClassAdvisor());
        if (params.getContainerCache().getInstanceContainer() != null) {
            proxy.setInstanceAdvisor(params.getContainerCache().getInstanceContainer());
        }
        if (params.getSimpleMetaData() != null) {
            proxy.setMetadata(params.getSimpleMetaData());
        }
        if (params.getTarget() != null) {
            ((Delegate)((Object)proxy)).setDelegate(params.getTarget());
        } else {
            ((Delegate)((Object)proxy)).setDelegate(new Object());
        }
        ((Delegate)((Object)proxy)).setContainerProxyCacheKey(params.getContainerCache().getKey());
        return proxy;
    }
}

