/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyMethodInvocation;

public class PerJoinpointAdvice
extends AbstractAdvice {
    private boolean initialized = false;
    AspectDefinition aspectDefinition;
    Joinpoint joinpoint;

    public static Interceptor createInterceptor(Advisor advisor, Joinpoint joinpoint, AspectDefinition def, String adviceName) throws Exception {
        if (joinpoint instanceof MethodJoinpoint) {
            MethodJoinpoint method = (MethodJoinpoint)joinpoint;
            if (Modifier.isStatic(method.getMethod().getModifiers())) {
                return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
            }
        } else {
            FieldJoinpoint field;
            if (joinpoint instanceof ConstructorJoinpoint) {
                return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
            }
            if (joinpoint instanceof MethodCalledByMethodJoinpoint) {
                MethodCalledByMethodJoinpoint method = (MethodCalledByMethodJoinpoint)joinpoint;
                if (Modifier.isStatic(method.getCalling().getModifiers())) {
                    return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
                }
            } else if (joinpoint instanceof ConstructorCalledByMethodJoinpoint) {
                ConstructorCalledByMethodJoinpoint method = (ConstructorCalledByMethodJoinpoint)joinpoint;
                if (Modifier.isStatic(method.getCalling().getModifiers())) {
                    return PerVmAdvice.generateInterceptor(joinpoint, def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
                }
            } else if (joinpoint instanceof FieldJoinpoint && Modifier.isStatic((field = (FieldJoinpoint)joinpoint).getField().getModifiers())) {
                ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
                Object aspect = classAdvisor.getFieldAspect(field, def);
                return PerVmAdvice.generateInterceptor(joinpoint, aspect, adviceName);
            }
        }
        return new PerJoinpointAdvice(adviceName, def, advisor, joinpoint);
    }

    public PerJoinpointAdvice(String adviceName, AspectDefinition a, Advisor advisor, Joinpoint joinpoint) {
        this.aspectDefinition = a;
        this.adviceName = adviceName;
        advisor.addPerInstanceJoinpointAspect(joinpoint, a);
        this.joinpoint = joinpoint;
    }

    public String getName() {
        return this.aspectDefinition.getName() + "." + this.adviceName;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object advisor;
        Object aspect = null;
        if (invocation instanceof CallerInvocation) {
            Object callingObject = ((CallerInvocation)invocation).getCallingObject();
            if (callingObject == null) {
                return invocation.invokeNext();
            }
            Advised advised = (Advised)callingObject;
            advisor = advised._getInstanceAdvisor();
            aspect = advisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
        } else {
            Object targetObject = invocation.getTargetObject();
            if (targetObject == null) {
                return invocation.invokeNext();
            }
            InstanceAdvisor instanceAdvisor = null;
            if (targetObject instanceof Advised) {
                Advised advised = (Advised)targetObject;
                instanceAdvisor = advised._getInstanceAdvisor();
            } else {
                advisor = invocation.getAdvisor();
                if (advisor == null) {
                    return invocation.invokeNext();
                }
                if (advisor instanceof InstanceAdvisor) {
                    instanceAdvisor = (InstanceAdvisor)advisor;
                } else if (advisor instanceof ClassProxyContainer && invocation instanceof ContainerProxyMethodInvocation) {
                    ContainerProxyMethodInvocation pi = (ContainerProxyMethodInvocation)invocation;
                    instanceAdvisor = pi.getProxy().getInstanceAdvisor();
                } else {
                    return invocation.invokeNext();
                }
            }
            aspect = instanceAdvisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
        }
        if (!this.initialized) {
            this.init(this.adviceName, aspect.getClass());
            this.initialized = true;
        }
        Method advice = this.resolveAdvice(invocation);
        Object[] args = new Object[]{invocation};
        try {
            return advice.invoke(aspect, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public Object getAspectInstance() {
        throw new RuntimeException("Use getAspectInstance(InstanceAdvisor instanceAdvisor) instead");
    }

    public Object getAspectInstance(InstanceAdvisor instanceAdvisor) {
        return instanceAdvisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
    }
}

