/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.annotation.PortableAnnotationElement;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.pointcut.ConstructorMatcher;
import org.jboss.aop.pointcut.FieldGetMatcher;
import org.jboss.aop.pointcut.MatcherStrategy;
import org.jboss.aop.pointcut.MethodMatcher;
import org.jboss.aop.pointcut.SecurityActions;
import org.jboss.aop.pointcut.Typedef;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.aop.util.MethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static boolean matchesClassExpr(ClassExpression classExpr, CtClass clazz, Advisor advisor) {
        try {
            if (classExpr.isAnnotation()) {
                String sub = classExpr.getOriginal().substring(1);
                if (advisor != null) {
                    if (advisor.getClassMetaData().hasTag(sub)) {
                        return true;
                    }
                    return advisor.hasAnnotation(clazz, sub);
                }
                return AnnotationElement.isAnyAnnotationPresent(clazz, sub);
            }
            if (classExpr.isInstanceOf()) {
                return Util.subtypeOf(clazz, classExpr, advisor);
            }
            if (classExpr.isTypedef()) {
                return Util.matchesTypedef(clazz, classExpr, advisor);
            }
            return classExpr.matches(clazz.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matchesClassExpr(ClassExpression classExpr, Class<?> clazz) {
        return Util.matchesClassExpr(classExpr, clazz, null);
    }

    public static boolean matchesClassExpr(ClassExpression classExpr, Class<?> clazz, Advisor advisor) {
        try {
            if (classExpr.isAnnotation()) {
                String sub = classExpr.getOriginal().substring(1);
                if (advisor != null) {
                    if (advisor.getClassMetaData().hasTag(sub)) {
                        return true;
                    }
                    return advisor.hasAnnotation(clazz, sub);
                }
                return AnnotationElement.isAnyAnnotationPresent(clazz, sub);
            }
            if (classExpr.isInstanceOf()) {
                return Util.subtypeOf(clazz, classExpr, advisor);
            }
            if (classExpr.isTypedef()) {
                return Util.matchesTypedef(clazz, classExpr, advisor);
            }
            return classExpr.matches(clazz.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean methodExistsInSuperClassOrInterface(Method method, ClassExpression target, boolean exactSuper, Advisor advisor) throws Exception {
        long hash = MethodHashing.calculateHash(method);
        boolean exists = Util.methodExistsInSuperClassOrInterface(hash, target, method.getDeclaringClass(), exactSuper);
        if (!exists) {
            exists = Util.checkMethodExistsInIntroductions(hash, target, exactSuper, advisor);
        }
        return exists;
    }

    private static boolean methodExistsInSuperClassOrInterface(long hash, ClassExpression expr, Class<?> clazz, boolean exactSuper) throws Exception {
        String sub;
        if (clazz == null) {
            return false;
        }
        if (expr.isAnnotation() ? AnnotationElement.isAnyAnnotationPresent(clazz, sub = expr.getOriginal().substring(1)) && Util.classHasMethod(clazz, hash, exactSuper) : expr.matches(clazz.getName()) && Util.classHasMethod(clazz, hash, exactSuper)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Util.methodExistsInSuperClassOrInterface(hash, expr, interfaces[i], exactSuper)) continue;
            return true;
        }
        if (clazz.isInterface()) {
            return false;
        }
        return Util.methodExistsInSuperClassOrInterface(hash, expr, clazz.getSuperclass(), exactSuper);
    }

    private static boolean checkMethodExistsInIntroductions(long hash, ClassExpression target, boolean exactSuper, Advisor advisor) throws Exception {
        ArrayList<InterfaceIntroduction> intros;
        if (advisor != null && (intros = advisor.getInterfaceIntroductions()).size() > 0) {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            ClassPool pool = advisor.getManager().findClassPool(tcl);
            HashSet<String> doneClasses = new HashSet<String>();
            for (InterfaceIntroduction intro : intros) {
                String[] ifs = intro.getInterfaces();
                for (int i = 0; ifs != null && i < ifs.length; ++i) {
                    if (doneClasses.contains(ifs[i])) continue;
                    doneClasses.add(ifs[i]);
                    if (!Util.methodExistsInSuperClassOrInterface(pool, hash, target, ifs[i], exactSuper)) continue;
                    return true;
                }
                ArrayList<InterfaceIntroduction.Mixin> mixins = intro.getMixins();
                if (mixins == null || mixins.size() <= 0) continue;
                for (InterfaceIntroduction.Mixin mixin : mixins) {
                    String[] mifs = mixin.getInterfaces();
                    for (int i = 0; mifs != null && i < mifs.length; ++i) {
                        if (doneClasses.contains(mifs[i])) continue;
                        doneClasses.add(mifs[i]);
                        if (!Util.methodExistsInSuperClassOrInterface(pool, hash, target, mifs[i], exactSuper)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean classHasMethod(Class<?> clazz, long hash, boolean exactSuper) throws Exception {
        Method m = MethodHashing.findMethodByHash(clazz, hash);
        if (m != null) {
            if (exactSuper) {
                return clazz == m.getDeclaringClass();
            }
            return true;
        }
        return false;
    }

    public static boolean methodExistsInSuperClassOrInterface(CtMethod method, ClassExpression target, boolean exactSuper) throws Exception {
        long hash = JavassistMethodHashing.methodHash(method);
        return Util.methodExistsInSuperClassOrInterface(hash, target, method.getDeclaringClass(), exactSuper);
    }

    private static boolean methodExistsInSuperClassOrInterface(ClassPool pool, long hash, ClassExpression expr, String className, boolean exactSuper) throws Exception {
        CtClass clazz = pool.get(className);
        return Util.methodExistsInSuperClassOrInterface(hash, expr, clazz, exactSuper);
    }

    private static boolean methodExistsInSuperClassOrInterface(long hash, ClassExpression expr, CtClass clazz, boolean exactSuper) throws Exception {
        String sub;
        if (clazz == null) {
            return false;
        }
        if (expr.isAnnotation() ? AnnotationElement.isAnyAnnotationPresent(clazz, sub = expr.getOriginal().substring(1)) && Util.classHasMethod(clazz, hash, exactSuper) : expr.matches(clazz.getName()) && Util.classHasMethod(clazz, hash, exactSuper)) {
            return true;
        }
        CtClass[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Util.methodExistsInSuperClassOrInterface(hash, expr, interfaces[i], exactSuper)) continue;
            return true;
        }
        if (clazz.isInterface()) {
            return false;
        }
        return Util.methodExistsInSuperClassOrInterface(hash, expr, clazz.getSuperclass(), exactSuper);
    }

    private static boolean classHasMethod(CtClass clazz, long hash, boolean exactSuper) throws Exception {
        HashMap<Long, CtMethod> methods = JavassistMethodHashing.getMethodMap(clazz);
        CtMethod m = methods.get(new Long(hash));
        if (m != null) {
            if (exactSuper) {
                return clazz == m.getDeclaringClass();
            }
            return true;
        }
        if (clazz.isInterface() && !exactSuper) {
            CtClass[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Util.classHasMethod(interfaces[i], hash, exactSuper)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean subtypeOf(CtClass clazz, ClassExpression instanceOf, Advisor advisor) {
        try {
            if (clazz == null) {
                return false;
            }
            if (instanceOf.isInstanceOfAnnotated()) {
                if (clazz.isPrimitive()) {
                    return false;
                }
                String sub = instanceOf.getInstanceOfAnnotation().substring(1);
                if (PortableAnnotationElement.isAnyAnnotationPresent(clazz, sub)) {
                    return true;
                }
            } else if (instanceOf.matches(clazz.getName())) {
                return true;
            }
            CtClass[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Util.subtypeOf(interfaces[i], instanceOf, advisor)) continue;
                return true;
            }
            if (clazz.isInterface()) {
                return false;
            }
            if (Util.checkIntroductions(clazz, instanceOf, advisor)) {
                return true;
            }
            return Util.subtypeOf(clazz.getSuperclass(), instanceOf, advisor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean checkIntroductions(CtClass clazz, ClassExpression instanceOf, Advisor advisor) {
        try {
            if (advisor != null) {
                ClassLoader cl = SecurityActions.getContextClassLoader();
                ArrayList<InterfaceIntroduction> intros = advisor.getInterfaceIntroductions();
                if (intros.size() > 0) {
                    for (InterfaceIntroduction intro : intros) {
                        ArrayList<InterfaceIntroduction.Mixin> mixins;
                        String[] introductions = intro.getInterfaces();
                        if (introductions != null) {
                            for (int i = 0; i < introductions.length; ++i) {
                                Class<?> iface = cl.loadClass(introductions[i]);
                                if (!Util.subtypeOf(iface, instanceOf, advisor)) continue;
                                return true;
                            }
                        }
                        if ((mixins = intro.getMixins()).size() <= 0) continue;
                        for (InterfaceIntroduction.Mixin mixin : mixins) {
                            String[] mixinInterfaces = mixin.getInterfaces();
                            if (mixinInterfaces == null) continue;
                            for (int i = 0; i < mixinInterfaces.length; ++i) {
                                Class<?> iface = cl.loadClass(mixinInterfaces[i]);
                                if (!Util.subtypeOf(iface, instanceOf, advisor)) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static boolean subtypeOf(Class<?> clazz, ClassExpression instanceOf, Advisor advisor) {
        return MatcherStrategy.getMatcher(advisor).subtypeOf(clazz, instanceOf, advisor);
    }

    public static boolean has(CtClass target, ASTMethod method, Advisor advisor) {
        return Util.has(target, method, advisor, true);
    }

    public static boolean has(CtClass target, ASTMethod method, Advisor advisor, boolean checkSuper) {
        try {
            CtClass superClass;
            CtMethod[] methods = target.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodMatcher matcher = new MethodMatcher(advisor, methods[i], null);
                if (!matcher.matches(method).booleanValue()) continue;
                return true;
            }
            if (checkSuper && (superClass = target.getSuperclass()) != null) {
                return Util.has(superClass, method, advisor, checkSuper);
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static boolean has(CtClass target, ASTField field, Advisor advisor) {
        return Util.has(target, field, advisor, true);
    }

    public static boolean has(CtClass target, ASTField field, Advisor advisor, boolean checkSuper) {
        try {
            CtClass superClass;
            CtField[] fields = target.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                FieldGetMatcher matcher = new FieldGetMatcher(advisor, fields[i], null);
                if (!((Boolean)field.jjtAccept(matcher, null)).booleanValue()) continue;
                return true;
            }
            if (checkSuper && (superClass = target.getSuperclass()) != null) {
                return Util.has(superClass, field, advisor, checkSuper);
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static boolean has(CtClass target, ASTConstructor con, Advisor advisor) {
        try {
            CtConstructor[] cons = target.getDeclaredConstructors();
            for (int i = 0; i < cons.length; ++i) {
                ConstructorMatcher matcher = new ConstructorMatcher(advisor, cons[i], null);
                if (!matcher.matches(con).booleanValue()) continue;
                return true;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static boolean has(Class<?> target, ASTMethod method, Advisor advisor) {
        return Util.has(target, method, advisor, true);
    }

    public static boolean has(Class<?> target, ASTMethod method, Advisor advisor, boolean checkSuper) {
        Class<?> superClass;
        Method[] methods = advisor.getAllMethods();
        if (methods == null) {
            methods = target.getDeclaredMethods();
        }
        for (int i = 0; i < methods.length; ++i) {
            MethodMatcher matcher = new MethodMatcher(advisor, methods[i], null);
            if (!matcher.matches(method).booleanValue()) continue;
            return true;
        }
        if (checkSuper && (superClass = target.getSuperclass()) != null) {
            return Util.has(superClass, method, advisor, checkSuper);
        }
        return false;
    }

    public static boolean has(Class<?> target, ASTField field, Advisor advisor) {
        return Util.has(target, field, advisor, true);
    }

    public static boolean has(Class<?> target, ASTField field, Advisor advisor, boolean checkSuper) {
        Class<?> superClass;
        Field[] fields = target.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldGetMatcher matcher = new FieldGetMatcher(advisor, fields[i], null);
            if (!((Boolean)field.jjtAccept(matcher, null)).booleanValue()) continue;
            return true;
        }
        if (checkSuper && (superClass = target.getSuperclass()) != null) {
            return Util.has(superClass, field, advisor, checkSuper);
        }
        return false;
    }

    public static boolean has(Class<?> target, ASTConstructor con, Advisor advisor) {
        Constructor<?>[] cons = target.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            ConstructorMatcher matcher = new ConstructorMatcher(advisor, cons[i], null);
            if (!matcher.matches(con).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesTypedef(CtClass clazz, ClassExpression classExpr, Advisor advisor) {
        String original;
        String typedefName;
        AspectManager manager = advisor != null ? advisor.getManager() : AspectManager.instance();
        Typedef typedef = manager.getTypedef(typedefName = (original = classExpr.getOriginal()).substring("$typedef{".length(), original.lastIndexOf("}")));
        if (typedef == null) {
            return false;
        }
        return typedef.matches(advisor, clazz);
    }

    public static boolean matchesTypedef(Class<?> clazz, ClassExpression classExpr, Advisor advisor) {
        String original;
        String typedefName;
        AspectManager manager = advisor != null ? advisor.getManager() : AspectManager.instance();
        Typedef typedef = manager.getTypedef(typedefName = (original = classExpr.getOriginal()).substring("$typedef{".length(), original.lastIndexOf("}")));
        if (typedef == null) {
            return false;
        }
        return typedef.matches(advisor, clazz);
    }

    public static boolean matchModifiers(ASTAttribute need, int have) {
        switch (need.attribute) {
            case 1024: {
                return Modifier.isAbstract(have) != need.not;
            }
            case 16: {
                return Modifier.isFinal(have) != need.not;
            }
            case 512: {
                return Modifier.isInterface(have) != need.not;
            }
            case 256: {
                return Modifier.isNative(have) != need.not;
            }
            case 2: {
                return Modifier.isPrivate(have) != need.not;
            }
            case 4: {
                return Modifier.isProtected(have) != need.not;
            }
            case 1: {
                return Modifier.isPublic(have) != need.not;
            }
            case 8: {
                return Modifier.isStatic(have) != need.not;
            }
            case 2048: {
                return Modifier.isStrict(have) != need.not;
            }
            case 32: {
                return Modifier.isSynchronized(have) != need.not;
            }
            case 128: {
                return Modifier.isTransient(have) != need.not;
            }
            case 64: {
                return Modifier.isVolatile(have) != need.not;
            }
        }
        throw new RuntimeException("Unexpected modifier value: " + need.attribute);
    }

    public static boolean matchExceptions(ArrayList<ASTException> nodeExceptions, CtClass[] foundExceptions) {
        if (nodeExceptions.size() > foundExceptions.length) {
            return false;
        }
        if (nodeExceptions.size() > 0) {
            for (ASTException ex : nodeExceptions) {
                boolean found = false;
                for (int i = 0; i < foundExceptions.length; ++i) {
                    if (!ex.getType().matches(foundExceptions[i].getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean matchExceptions(ArrayList<ASTException> nodeExceptions, Class<?>[] foundExceptions) {
        if (nodeExceptions.size() > foundExceptions.length) {
            return false;
        }
        Iterator<ASTException> it = nodeExceptions.iterator();
        while (it.hasNext()) {
            boolean found = false;
            ASTException ex = it.next();
            for (int i = 0; i < foundExceptions.length; ++i) {
                if (!ex.getType().matches(foundExceptions[i].getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesParameters(Advisor advisor, ASTMethod node, CtMethod ctMethod) {
        if (node.isAnyParameters()) {
            return true;
        }
        try {
            return Util.matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), (ArrayList<ASTParameter>)node.getParameters(), ctMethod.getParameterTypes());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matchesParameters(Advisor advisor, ASTConstructor node, CtConstructor ctConstructor) {
        if (node.isAnyParameters()) {
            return true;
        }
        try {
            CtClass[] params = ctConstructor.getParameterTypes();
            return Util.matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), (ArrayList<ASTParameter>)node.getParameters(), params);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matchesParameters(Advisor advisor, ASTMethod node, Method method) {
        if (node.isAnyParameters()) {
            return true;
        }
        return Util.matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), (ArrayList<ASTParameter>)node.getParameters(), method.getParameterTypes());
    }

    public static boolean matchesParameters(Advisor advisor, ASTConstructor node, Constructor<?> con) {
        if (node.isAnyParameters()) {
            return true;
        }
        return Util.matchesParameters(advisor, node.hasAnyZeroOrMoreParameters(), (ArrayList<ASTParameter>)node.getParameters(), con.getParameterTypes());
    }

    private static boolean matchesParameters(Advisor advisor, boolean hasAnyZeroOrMoreParameters, ArrayList<ASTParameter> parameters, Class<?>[] params) {
        RefParameterMatcher matcher = new RefParameterMatcher(advisor, parameters, params);
        return matcher.matches();
    }

    private static boolean matchesParameters(Advisor advisor, boolean hasAnyZeroOrMoreParameters, ArrayList<ASTParameter> parameters, CtClass[] params) {
        CtParameterMatcher matcher = new CtParameterMatcher(advisor, parameters, params);
        return matcher.matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CtParameterMatcher
    extends ParameterMatcher {
        CtClass[] params;

        public CtParameterMatcher(Advisor advisor, ArrayList<ASTParameter> parameters, CtClass[] params) {
            super(advisor, parameters, params);
            this.params = params;
        }

        @Override
        boolean doMatch(int astIndex, int actualIndex) {
            ASTParameter ast = (ASTParameter)this.astParameters.get(astIndex);
            ClassExpression exp = ast.getType();
            return Util.matchesClassExpr(exp, this.params[actualIndex], this.advisor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefParameterMatcher
    extends ParameterMatcher {
        Class<?>[] params;

        public RefParameterMatcher(Advisor advisor, ArrayList<ASTParameter> parameters, Class<?>[] params) {
            super(advisor, parameters, params);
            this.params = params;
        }

        @Override
        boolean doMatch(int astIndex, int actualIndex) {
            String asString;
            ASTParameter ast = (ASTParameter)this.astParameters.get(astIndex);
            ClassExpression exp = ast.getType();
            return !(exp.isSimple() ? !exp.matches(asString = ClassExpression.simpleType(this.params[actualIndex])) : !Util.matchesClassExpr(exp, this.params[actualIndex], this.advisor));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ParameterMatcher {
        Advisor advisor;
        ArrayList<ASTParameter> astParameters;
        final long paramsLength;
        private int asti;
        private int actuali;

        ParameterMatcher(Advisor advisor, ArrayList<ASTParameter> parameters, Object[] params) {
            this.advisor = advisor;
            this.astParameters = parameters;
            this.paramsLength = params.length;
        }

        boolean matches() {
            return this.matches(0, 0);
        }

        private boolean matches(int ast, int actual) {
            boolean match = true;
            while (match && ast < this.astParameters.size() && (long)actual < this.paramsLength) {
                if (this.isAnyZeroOrMoreParameters(ast)) {
                    this.asti = ast;
                    this.actuali = actual;
                    match = this.wildcard();
                    ast = this.asti;
                    actual = this.actuali;
                    --ast;
                } else {
                    match = this.doMatch(ast, actual);
                    ++actual;
                }
                ++ast;
            }
            while (match && ast < this.astParameters.size() && this.isAnyZeroOrMoreParameters(ast)) {
                ++ast;
            }
            return match && ast == this.astParameters.size() && this.paramsLength == (long)actual;
        }

        private boolean isAnyZeroOrMoreParameters(int index) {
            return this.astParameters.get(index).isAnyZeroOrMoreParameters();
        }

        abstract boolean doMatch(int var1, int var2);

        private boolean wildcard() {
            do {
                ++this.asti;
            } while (this.asti < this.astParameters.size() && this.isAnyZeroOrMoreParameters(this.asti));
            if ((long)this.actuali == this.paramsLength) {
                return this.asti >= this.astParameters.size();
            }
            int currentAsti = this.asti;
            int currentActuali = this.actuali;
            while (!this.matches(this.asti, this.actuali) && (long)this.actuali < this.paramsLength) {
                this.asti = currentAsti;
                this.actuali = currentActuali;
                do {
                    ++this.actuali;
                } while ((long)this.actuali < this.paramsLength && this.asti < this.astParameters.size() && !this.doMatch(this.asti, this.actuali));
                currentAsti = this.asti;
                currentActuali = this.actuali;
            }
            return true;
        }
    }
}

