/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.Domain;
import org.jboss.aop.asintegration.jboss5.DomainRegistry;
import org.jboss.aop.asintegration.jboss5.ScopedVFSClassLoaderDomain;
import org.jboss.aop.asintegration.jboss5.SecurityActions;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;

public class VFSClassLoaderDomainRegistry
implements DomainRegistry {
    static final ClassLoaderDomain domain = new ClassLoaderDomain("NOT_USED_PLACEHOLDER");
    private Map<ClassLoader, WeakReference<ClassLoaderDomain>> classLoaderDomainsByLoader = new WeakHashMap<ClassLoader, WeakReference<ClassLoaderDomain>>();
    private Map<ClassLoaderDomain, ScopedVFSClassLoaderDomain> aopDomainsByClassLoaderDomain = new WeakHashMap<ClassLoaderDomain, ScopedVFSClassLoaderDomain>();
    private Map<ClassLoader, WeakReference<ClassLoader>> classLoaderUnitParents = new WeakHashMap<ClassLoader, WeakReference<ClassLoader>>();
    private Map<ClassLoader, WeakReference<Module>> classLoaderModules = new WeakHashMap<ClassLoader, WeakReference<Module>>();
    private Map<ClassLoaderDomain, Integer> classLoaderDomainReferenceCounts = new WeakHashMap<ClassLoaderDomain, Integer>();

    public synchronized boolean initMapsForLoader(ClassLoader loader, Module module, ScopedVFSClassLoaderDomain domain, ClassLoader parentUnitLoader) {
        if (loader == parentUnitLoader) {
            throw new IllegalArgumentException("initMapsForLoader() should only be called if parentUnitLoader is different from loader");
        }
        ClassLoaderSystem system = ClassLoaderSystem.getInstance();
        String domainName = module.getDeterminedDomainName();
        ClassLoaderDomain clDomain = system.getDomain(domainName);
        boolean ret = false;
        if (!this.classLoaderDomainsByLoader.containsKey(loader)) {
            Integer count = this.classLoaderDomainReferenceCounts.get(clDomain);
            int cnt = count == null ? 0 : count;
            this.classLoaderDomainReferenceCounts.put(clDomain, ++cnt);
            this.classLoaderDomainsByLoader.put(loader, new WeakReference<ClassLoaderDomain>(clDomain));
            this.classLoaderUnitParents.put(loader, new WeakReference<ClassLoader>(parentUnitLoader));
            this.classLoaderModules.put(loader, new WeakReference<Module>(module));
            ret = true;
            if (domain != null) {
                this.aopDomainsByClassLoaderDomain.put(clDomain, domain);
            }
        }
        return ret;
    }

    public synchronized void cleanupLoader(ClassLoader loader) {
        ClassLoaderDomain clDomain;
        WeakReference<ClassLoaderDomain> clDomainRef = this.classLoaderDomainsByLoader.remove(loader);
        ClassLoaderDomain classLoaderDomain = clDomain = clDomainRef == null ? null : (ClassLoaderDomain)clDomainRef.get();
        if (clDomain != null) {
            int cnt;
            Integer count = this.classLoaderDomainReferenceCounts.get(clDomain);
            int n = cnt = count == null ? 0 : count;
            if (cnt > 0) {
                --cnt;
            }
            if (cnt == 0) {
                this.aopDomainsByClassLoaderDomain.remove(clDomain);
                this.classLoaderDomainReferenceCounts.remove(clDomain);
            } else {
                this.classLoaderDomainReferenceCounts.put(clDomain, cnt);
            }
            this.classLoaderUnitParents.remove(loader);
            this.classLoaderModules.remove(loader);
        }
    }

    public synchronized Domain getRegisteredDomain(ClassLoader cl) {
        ClassLoaderDomain clDomain = this.getClassLoaderDomainForLoader(cl);
        if (clDomain != null) {
            return (Domain)this.aopDomainsByClassLoaderDomain.get(clDomain);
        }
        return null;
    }

    public synchronized ClassLoaderDomain getClassLoaderDomainForLoader(ClassLoader cl) {
        ClassLoaderDomain domain;
        WeakReference<ClassLoaderDomain> clDomainRef = this.classLoaderDomainsByLoader.get(cl);
        if (clDomainRef != null) {
            return (ClassLoaderDomain)clDomainRef.get();
        }
        ClassLoader parent = SecurityActions.getParent(cl);
        if (parent != null && (domain = this.getClassLoaderDomainForLoader(parent)) != null) {
            this.classLoaderDomainsByLoader.put(parent, new WeakReference<ClassLoaderDomain>(domain));
            return domain;
        }
        return null;
    }

    public synchronized ClassLoader getParentUnitLoader(ClassLoader loader) {
        WeakReference<ClassLoader> parentRef = this.classLoaderUnitParents.get(loader);
        if (parentRef != null) {
            return (ClassLoader)parentRef.get();
        }
        return null;
    }

    public synchronized Module getModule(ClassLoader loader) {
        WeakReference<Module> moduleRef = this.classLoaderModules.get(loader);
        if (moduleRef != null) {
            return (Module)moduleRef.get();
        }
        return null;
    }
}

