/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.aophelper.core.AopBaseSettings;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopRun;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfigParser {
    public static void parse(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            Node aophelper = BaseConfigParser.findElementNode("aophelper", doc);
            Node compile = BaseConfigParser.findElementNode("compile", aophelper);
            Node run = BaseConfigParser.findElementNode("run", aophelper);
            AopHandler.instance().setRun(BaseConfigParser.parseCompile(compile));
            AopHandler.instance().setRun(BaseConfigParser.parseRun(run));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static AopRun parseCompile(Node compile) {
        AopRun compileSettings = new AopRun();
        BaseConfigParser.parseBaseSettings(compile, compileSettings);
        return compileSettings;
    }

    private static void parseBaseSettings(Node root, AopBaseSettings base) {
        Node classpaths = BaseConfigParser.findElementNode("classpaths", root);
        base.setClasspath(BaseConfigParser.getNodesText(classpaths.getChildNodes()));
        Node aopxmls = BaseConfigParser.findElementNode("aopxmls", root);
        base.setAopXml(BaseConfigParser.getNodesText(aopxmls.getChildNodes()));
        Node options = BaseConfigParser.findElementNode("options", root);
        Node verbose = BaseConfigParser.findElementNode("verbose", options);
        base.setVerbose(BaseConfigParser.getNodeText(verbose).equals("true"));
        Node suppress = BaseConfigParser.findElementNode("suppress", options);
        base.setSuppress(BaseConfigParser.getNodeText(suppress).equals("true"));
        Node noopt = BaseConfigParser.findElementNode("noopt", options);
        base.setNoopt(BaseConfigParser.getNodeText(noopt).equals("true"));
        Node report = BaseConfigParser.findElementNode("report", options);
        base.setReport(BaseConfigParser.getNodeText(report).equals("true"));
        Node workingdir = BaseConfigParser.findElementNode("workingdir", root);
        base.setWorkingdir(BaseConfigParser.getNodeText(workingdir));
    }

    private static AopRun parseRun(Node run) {
        AopRun aopRun = new AopRun();
        BaseConfigParser.parseBaseSettings(run, aopRun);
        Node loadtime = BaseConfigParser.findElementNode("loadtime", run);
        aopRun.setLoadtime(BaseConfigParser.getNodeText(loadtime).equals("true"));
        Node exeClass = BaseConfigParser.findElementNode("execlass", run);
        aopRun.setExecutionClass(BaseConfigParser.getNodeText(exeClass));
        return aopRun;
    }

    private static Node findElementNode(String elementName, Node root) {
        Node matchingNode = null;
        String nodeName = root.getNodeName();
        if (nodeName != null & nodeName.equals(elementName)) {
            return root;
        }
        if (!root.hasChildNodes()) {
            return null;
        }
        NodeList childNodes = root.getChildNodes();
        int noChildren = childNodes.getLength();
        for (int i = 0; i < noChildren && matchingNode == null; ++i) {
            Node child = childNodes.item(i);
            matchingNode = BaseConfigParser.findElementNode(elementName, child);
        }
        return matchingNode;
    }

    private static String getNodeText(Node node) {
        if (node.getNodeType() == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue();
            }
        } else if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    private static List<String> getNodesText(NodeList list) {
        ArrayList<String> text = new ArrayList<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            String t = BaseConfigParser.getNodeText(list.item(i)).trim();
            if (t == null || t.length() <= 0) continue;
            text.add(t);
        }
        return text;
    }

    public static String getSettingsAsString() {
        try {
            Document doc = BaseConfigParser.createDOM();
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Document createDOM() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("aophelper");
            Element compile = doc.createElement("compile");
            Element run = doc.createElement("run");
            BaseConfigParser.populateCompile(compile, doc);
            BaseConfigParser.populateRun(run, doc);
            root.appendChild(compile);
            root.appendChild(run);
            doc.appendChild(root);
            return doc;
        }
        catch (ParserConfigurationException e) {
            System.out.println("ERROR in CreateDOM \n" + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    private static void populateCompile(Element compile, Document doc) {
        BaseConfigParser.populateBase(compile, doc, AopHandler.instance().getRun());
    }

    private static void populateRun(Element run, Document doc) {
        BaseConfigParser.populateBase(run, doc, AopHandler.instance().getRun());
        Element loadtime = doc.createElement("loadtime");
        loadtime.appendChild(doc.createTextNode(Boolean.toString(AopHandler.instance().getRun().isLoadtime())));
        run.appendChild(loadtime);
        Element exeClass = doc.createElement("execlass");
        if (AopHandler.instance().getRun().getExecutionClass() != null) {
            exeClass.appendChild(doc.createTextNode(AopHandler.instance().getRun().getExecutionClass()));
        }
        run.appendChild(exeClass);
    }

    private static void populateBase(Element base, Document doc, AopBaseSettings settings) {
        Element classpaths = doc.createElement("classpaths");
        for (String cp : settings.getClasspath()) {
            Element classpath = doc.createElement("classpath");
            classpath.appendChild(doc.createTextNode(cp));
            classpaths.appendChild(classpath);
        }
        base.appendChild(classpaths);
        Element aopxmls = doc.createElement("aopxmls");
        for (String xml : settings.getAopXml()) {
            Element xmlaop = doc.createElement("aopxml");
            xmlaop.appendChild(doc.createTextNode(xml));
            aopxmls.appendChild(xmlaop);
        }
        base.appendChild(aopxmls);
        Element options = doc.createElement("options");
        Element verbose = doc.createElement("verbose");
        verbose.appendChild(doc.createTextNode(Boolean.toString(settings.isVerbose())));
        options.appendChild(verbose);
        Element suppress = doc.createElement("suppress");
        suppress.appendChild(doc.createTextNode(Boolean.toString(settings.isSuppress())));
        options.appendChild(suppress);
        Element noopt = doc.createElement("noopt");
        noopt.appendChild(doc.createTextNode(Boolean.toString(settings.isNoopt())));
        options.appendChild(noopt);
        Element report = doc.createElement("report");
        report.appendChild(doc.createTextNode(Boolean.toString(settings.isReport())));
        options.appendChild(report);
        base.appendChild(options);
        Element workingdir = doc.createElement("workingdir");
        if (settings.getWorkingdir() != null) {
            workingdir.appendChild(doc.createTextNode(settings.getWorkingdir()));
        }
        base.appendChild(workingdir);
    }
}

