/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui.run.classpath;

import org.jboss.aophelper.annotation.AopHelperAction;
import org.jboss.aophelper.core.Action;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.core.AopOption;
import org.jboss.aophelper.core.AopState;
import org.jboss.aophelper.ui.AopHelperUiMediator;
import org.jboss.aophelper.ui.GenericEditTableModel;
import org.jboss.aophelper.ui.GenericEditTablePane;
import org.jboss.aophelper.ui.run.classpath.RunClasspathTableModel;

public class RunClasspathTablePane
extends GenericEditTablePane {
    private static final long serialVersionUID = 1L;
    private RunClasspathTableModel tableModel;

    public RunClasspathTablePane(String classpaths) {
        this.init();
        this.insertClasspaths(classpaths);
    }

    public void setMediatorTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new RunClasspathTableModel();
        }
        System.out.println("setting tablemodel to the mediator: " + this.tableModel.getClass().getName());
        AopHelperUiMediator.instance().setRunClasspathModel(this.tableModel);
    }

    public void setMediatorJPanel() {
        AopHelperUiMediator.instance().setRunClasspathTable(this);
    }

    public GenericEditTableModel getTableModel() {
        return this.tableModel;
    }

    @AopHelperAction(action=Action.SET, state=AopState.RUN, option=AopOption.CLASSPATH)
    public void notifyAction() {
    }

    private void insertClasspaths(String classpaths) {
        String[] cp;
        for (String path : cp = classpaths.split(System.getProperty("path.separator"))) {
            this.tableModel.addRow(path);
            AopHandler.instance().getRun().addClasspath(path);
        }
    }

    public void refresh() {
        this.tableModel.clearRows();
        this.tableModel.addRows(AopHandler.instance().getRun().getClasspath());
    }
}

