/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jboss.aophelper.ui.AopHelperMediator;
import org.jboss.aophelper.ui.AopHelperMenuBar;
import org.jboss.aophelper.ui.compile.CompilerPane;
import org.jboss.aophelper.ui.run.RunPane;

public class AopHelperFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JFileChooser fc;
    private CompilerPane compilerPane;
    private RunPane runPane;

    public AopHelperFrame() {
        super("JBoss AOP Helper");
        AopHelperMediator.instance().setMainPane(this);
        this.setup();
    }

    private void setup() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AopHelperMediator.instance().quit();
            }
        });
        this.compilerPane = new CompilerPane();
        this.runPane = new RunPane();
        AopHelperMediator.instance().setMenuBar(new AopHelperMenuBar());
        this.setJMenuBar(AopHelperMediator.instance().getMenuBar());
        this.setSize(1024, 768);
        this.setLocation();
        this.setVisible(true);
        AopHelperMediator.instance().setMainPane(this);
        this.fc = new JFileChooser();
        this.fc.setFileSelectionMode(2);
        this.fc.setMultiSelectionEnabled(true);
        this.setCompilerMode();
    }

    public void setLocation() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
    }

    public Point getMidPoint(int width, int height) {
        Point loc = this.getLocation();
        Dimension mainSize = this.getSize();
        return new Point((int)(mainSize.getWidth() / 2.0) - width / 2 + (int)loc.getX(), (int)(mainSize.getHeight() / 2.0) - height / 2 + (int)loc.getY());
    }

    public File[] createFileCooser() {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File[] files = this.fc.getSelectedFiles();
            return files;
        }
        System.out.println("Save command cancelled by user.");
        return new File[0];
    }

    public void setRunMode() {
        this.setContentPane(this.runPane);
        AopHelperMediator.instance().getMenuBar().setRunMode();
        this.pack();
    }

    public void setCompilerMode() {
        this.setContentPane(this.compilerPane);
        AopHelperMediator.instance().getMenuBar().setCompileMode();
        this.pack();
    }

    public void displayMessageDialog(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    public static void main(String[] args) {
        new AopHelperFrame();
    }
}

