/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns;

public enum MpnsResponse {
    RECEIVED(200, "received", "connected", "active", true, false),
    DISCONNECTED(200, "received", "disconnected", "active", true, false),
    QUEUED(200, "received", "tempdisconnected", "active", true, false),
    QUEUE_FULL(200, "queuefull", null, "active", false, true),
    SUPPRESSED(200, "suppressed", null, "active", false, false),
    DROPPED_BY_CLIENT(200, "dropped", "connected", "active", false, false),
    BAD_REQUEST(400, null, null, null, false, false),
    UNAUTHORIZED(401, null, null, null, false, false),
    EXPIRED(404, "dropped", null, "expired", false, false),
    METHOD_NOT_ALLOWED(405, null, null, null, false, false),
    OVER_LIMIT(406, "dropped", null, "active", false, true),
    INACTIVATE_STATE(412, "dropped", "inactive", null, false, true),
    SERVICE_UNAVAILABLE(503, null, null, null, false, true),
    UNDEFINED(0, null, null, null, false, true);

    private final int responseCode;
    private final String notificationStatus;
    private final String deviceConnectionStatus;
    private final String subscriptionStatus;
    private final boolean success;
    private final boolean shouldRetry;

    private MpnsResponse(int responseCode, String notificationStatus, String deviceConnectionStatus, String subscriptionStatus, boolean success, boolean requiresRetry) {
        this.responseCode = responseCode;
        this.notificationStatus = notificationStatus;
        this.deviceConnectionStatus = deviceConnectionStatus;
        this.subscriptionStatus = subscriptionStatus;
        this.success = success;
        this.shouldRetry = requiresRetry;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getNotificationStatus() {
        return this.notificationStatus;
    }

    public String getDeviceConnectionStatus() {
        return this.deviceConnectionStatus;
    }

    public String getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public boolean shouldRetry() {
        return this.shouldRetry;
    }
}

