/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.notifications;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.windows.mpns.DeliveryClass;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.internal.Utilities;
import org.jboss.aerogear.windows.mpns.notifications.AbstractNotificationBuilder;

public class RawNotification
implements MpnsNotification {
    private final byte[] body;
    private final List<? extends Map.Entry<String, String>> headers;

    public RawNotification(byte[] body, List<? extends Map.Entry<String, String>> headers) {
        this.body = body;
        this.headers = headers;
    }

    @Override
    public byte[] getRequestBody() {
        return this.body;
    }

    @Override
    public List<? extends Map.Entry<String, String>> getHttpHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public static class Builder
    extends AbstractNotificationBuilder<Builder, RawNotification> {
        private byte[] body;

        public Builder body(String body) {
            this.body = Utilities.toUTF8(body);
            return this;
        }

        public Builder body(byte[] body) {
            byte[] copy = new byte[body.length];
            System.arraycopy(body, 0, copy, 0, body.length);
            this.body = copy;
            return this;
        }

        @Override
        protected int deliveryValueOf(DeliveryClass delivery) {
            switch (delivery) {
                case IMMEDIATELY: {
                    return 3;
                }
                case WITHIN_450: {
                    return 13;
                }
                case WITHIN_900: {
                    return 23;
                }
            }
            throw new AssertionError((Object)("Unknown Value: " + (Object)((Object)delivery)));
        }

        @Override
        public RawNotification build() {
            return new RawNotification(this.body, this.headers);
        }
    }
}

