/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.TypedQuery;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.ResultStreamException;
import org.jboss.aerogear.unifiedpush.dao.ResultsStream;
import org.jboss.aerogear.unifiedpush.dto.Count;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAInstallationDao
extends JPABaseDao<Installation, String>
implements InstallationDao {
    private static final String FIND_ALL_DEVICES_FOR_VARIANT_QUERY = "select distinct installation.deviceToken from Installation installation left join installation.categories c  join installation.variant abstractVariant where abstractVariant.variantID = :variantID AND installation.enabled = true";
    private static final String FIND_INSTALLATIONS = "FROM Installation installation JOIN installation.variant v WHERE v.variantID = :variantID";

    public PageResult<Installation, Count> findInstallationsByVariantForDeveloper(String variantID, String developer, Integer page, Integer pageSize, String search) {
        StringBuilder jpqlBase = new StringBuilder(FIND_INSTALLATIONS);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("variantID", variantID);
        if (developer != null) {
            jpqlBase.append(" AND v.developer = :developer");
            parameters.put("developer", developer);
        }
        if (search != null) {
            jpqlBase.append(" AND ( installation.deviceToken LIKE :search OR installation.deviceType LIKE :search OR installation.platform LIKE :search OR installation.operatingSystem LIKE :search OR installation.osVersion LIKE :search OR installation.alias LIKE :search )");
            parameters.put("search", "%" + search + "%");
        }
        TypedQuery<Long> countQuery = this.createQuery("SELECT COUNT(installation) " + jpqlBase.toString(), Long.class);
        TypedQuery query = this.createQuery("SELECT installation " + jpqlBase.toString() + " ORDER BY installation.id").setFirstResult(page * pageSize).setMaxResults(pageSize.intValue());
        List resultList = this.setParameters(query, parameters).getResultList();
        Long count = (Long)this.setParameters(countQuery, parameters).getSingleResult();
        return new PageResult(resultList, (Object)new Count(count));
    }

    private <X> TypedQuery<X> setParameters(TypedQuery<X> query, Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public PageResult<Installation, Count> findInstallationsByVariant(String variantID, Integer page, Integer pageSize, String search) {
        return this.findInstallationsByVariantForDeveloper(variantID, null, page, pageSize, search);
    }

    public Installation findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return (Installation)this.getSingleResultForQuery(this.createQuery("select installation from Installation installation  join installation.variant abstractVariant where abstractVariant.variantID = :variantID and installation.deviceToken = :deviceToken").setParameter("variantID", (Object)variantID).setParameter("deviceToken", (Object)deviceToken));
    }

    public List<Installation> findInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        if (deviceTokens == null || deviceTokens.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createQuery("select installation from Installation installation  join installation.variant abstractVariant  where abstractVariant.variantID = :variantID and installation.deviceToken IN :deviceTokens").setParameter("variantID", (Object)variantID).setParameter("deviceTokens", deviceTokens).getResultList();
    }

    public Set<String> findAllDeviceTokenForVariantID(String variantID) {
        TypedQuery<String> query = this.createQuery(FIND_ALL_DEVICES_FOR_VARIANT_QUERY, String.class);
        query.setParameter("variantID", (Object)variantID);
        return new HashSet<String>(query.getResultList());
    }

    public ResultsStream.QueryBuilder<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes, final int maxResults, String lastTokenFromPreviousBatch) {
        final StringBuilder jpqlString = new StringBuilder(FIND_ALL_DEVICES_FOR_VARIANT_QUERY);
        final LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("variantID", variantID);
        this.appendDynamicQuery(jpqlString, parameters, categories, aliases, deviceTypes);
        if (lastTokenFromPreviousBatch != null) {
            jpqlString.append(" AND installation.deviceToken > :lastTokenFromPreviousBatch");
            parameters.put("lastTokenFromPreviousBatch", lastTokenFromPreviousBatch);
        }
        jpqlString.append(" ORDER BY installation.deviceToken ASC");
        return new ResultsStream.QueryBuilder<String>(){
            private Integer fetchSize = null;

            public ResultsStream.QueryBuilder<String> fetchSize(int fetchSize) {
                this.fetchSize = fetchSize;
                return this;
            }

            public ResultsStream<String> executeQuery() {
                Query hibernateQuery = JPAInstallationDao.this.createHibernateQuery(jpqlString.toString());
                hibernateQuery.setMaxResults(maxResults);
                for (Map.Entry parameter : parameters.entrySet()) {
                    Object value = parameter.getValue();
                    if (value instanceof Collection) {
                        hibernateQuery.setParameterList((String)parameter.getKey(), (Collection)parameter.getValue());
                        continue;
                    }
                    hibernateQuery.setParameter((String)parameter.getKey(), parameter.getValue());
                }
                hibernateQuery.setReadOnly(true);
                if (this.fetchSize != null) {
                    hibernateQuery.setFetchSize(this.fetchSize.intValue());
                }
                final ScrollableResults results = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
                return new ResultsStream<String>(){

                    public boolean next() throws ResultStreamException {
                        return results.next();
                    }

                    public String get() throws ResultStreamException {
                        return (String)results.get()[0];
                    }
                };
            }
        };
    }

    public long getNumberOfDevicesForLoginName(String loginName) {
        return (Long)this.createQuery("select count(installation) from Installation installation join installation.variant abstractVariant where abstractVariant.variantID IN (select t.variantID from Variant t where t.developer = :developer) ", Long.class).setParameter("developer", (Object)loginName).getSingleResult();
    }

    @Override
    public Class<Installation> getType() {
        return Installation.class;
    }

    public long getTotalNumberOfDevices() {
        return (Long)this.createQuery("select count(installation) from Installation installation join installation.variant abstractVariant where abstractVariant.variantID IN (select t.variantID from Variant t) ", Long.class).getSingleResult();
    }

    public long getNumberOfDevicesForVariantID(String variantId) {
        return (Long)this.createQuery("select count(installation) from Installation installation join installation.variant abstractVariant where abstractVariant.variantID = :variantId ", Long.class).setParameter("variantId", (Object)variantId).getSingleResult();
    }

    private void appendDynamicQuery(StringBuilder jpqlString, Map<String, Object> parameters, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        if (this.isListEmpty(aliases)) {
            jpqlString.append(" AND installation.alias IN :aliases");
            parameters.put("aliases", aliases);
        }
        if (this.isListEmpty(deviceTypes)) {
            jpqlString.append(" AND installation.deviceType IN :deviceTypes");
            parameters.put("deviceTypes", deviceTypes);
        }
        if (this.isListEmpty(categories)) {
            jpqlString.append(" AND ( c.name in (:categories))");
            parameters.put("categories", categories);
        }
    }

    private boolean isListEmpty(List list) {
        return list != null && !list.isEmpty();
    }
}

