/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Date;
import java.util.List;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

public class JPAPushMessageInformationDao
extends JPABaseDao
implements PushMessageInformationDao {
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private final AeroGearLogger logger = AeroGearLogger.getInstance(JPAPushMessageInformationDao.class);

    public List<PushMessageInformation> findAllForPushApplication(String pushApplicationId, boolean ascending) {
        return this.createQuery("select pmi from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending)).setParameter("pushApplicationId", (Object)pushApplicationId).getResultList();
    }

    public PageResult<PushMessageInformation> findAllForPushApplication(String pushApplicationId, boolean ascending, Integer page, Integer pageSize) {
        String query = "select pmi from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        String countQuery = "select count(*) from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId";
        return this.executePagedQuery(pushApplicationId, "pushApplicationId", page, pageSize, query, "select count(*) from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId");
    }

    public PageResult<PushMessageInformation> findAllForVariant(String variantID, boolean ascending, Integer page, Integer pageSize) {
        String query = "select pmi from PushMessageInformation pmi JOIN fetch pmi.variantInformations vi where vi.variantID = :variantID ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        String countQuery = "select count(*) from PushMessageInformation pmi JOIN pmi.variantInformations vi where vi.variantID = :variantID";
        return this.executePagedQuery(variantID, "variantID", page, pageSize, query, "select count(*) from PushMessageInformation pmi JOIN pmi.variantInformations vi where vi.variantID = :variantID");
    }

    private PageResult<PushMessageInformation> executePagedQuery(String param, String paramName, Integer page, Integer pageSize, String query, String countQuery) {
        List pushMessageInformationList = this.createQuery(query).setParameter(paramName, (Object)param).setFirstResult(page * pageSize).setMaxResults(pageSize.intValue()).getResultList();
        Long count = (Long)this.createQuery(countQuery).setParameter(paramName, (Object)param).getSingleResult();
        return new PageResult(pushMessageInformationList, count.longValue());
    }

    public long getNumberOfPushMessagesForApplications(String loginName) {
        return (Long)this.createQuery("select count(pmi) from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p where p.developer = :developer)").setParameter("developer", (Object)loginName).getSingleResult();
    }

    public PushMessageInformation find(String id) {
        return (PushMessageInformation)this.entityManager.find(PushMessageInformation.class, (Object)id);
    }

    public void create(PushMessageInformation pushMessageInformation) {
        this.persist(pushMessageInformation);
    }

    public void update(PushMessageInformation pushMessageInformation) {
        this.merge(pushMessageInformation);
    }

    public void delete(PushMessageInformation pushMessageInformation) {
        PushMessageInformation entity = this.find(pushMessageInformation.getId());
        this.remove(entity);
    }

    public List<String> findVariantIDsWithWarnings(String loginName) {
        return this.createQuery("select distinct vmi.variantID from VariantMetricInformation vmi where vmi.variantID IN (select t.variantID from Variant t where t.developer = :developer) and vmi.deliveryStatus = false").setParameter("developer", (Object)loginName).getResultList();
    }

    public List<PushMessageInformation> findLastThreeActivity(String loginName) {
        return this.createQuery("select pmi from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p where p.developer = :developer) ORDER BY pmi.submitDate DESC").setParameter("developer", (Object)loginName).setMaxResults(3).getResultList();
    }

    public void deletePushInformationOlderThan(Date oldest) {
        List oldMessages = this.createQuery("select pmi FROM PushMessageInformation pmi WHERE pmi.submitDate < :oldest").setParameter("oldest", (Object)oldest).getResultList();
        this.logger.info("Deleting ['" + oldMessages.size() + "'] outdated PushMessageInformation objects");
        for (PushMessageInformation oldMessage : oldMessages) {
            this.remove(oldMessage);
        }
    }

    public List<String> findVariantIDsWithWarnings() {
        return this.createQuery("select distinct vmi.variantID from VariantMetricInformation vmi where vmi.variantID IN (select t.variantID from Variant t) and vmi.deliveryStatus = false").getResultList();
    }

    public List<PushMessageInformation> findLastThreeActivity() {
        return this.createQuery("select pmi from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p) ORDER BY pmi.submitDate DESC").setMaxResults(3).getResultList();
    }

    public long getNumberOfPushMessagesForApplications() {
        return (Long)this.createQuery("select count(pmi) from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p)").getSingleResult();
    }

    private String ascendingOrDescending(boolean asc) {
        if (asc) {
            return ASC;
        }
        return DESC;
    }
}

