/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.dao.PushApplicationDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAPushApplicationDao
extends JPABaseDao
implements PushApplicationDao {
    public void create(PushApplication pushApplication) {
        this.persist(pushApplication);
    }

    public void update(PushApplication pushApplication) {
        this.merge(pushApplication);
    }

    public void delete(PushApplication pushApplication) {
        PushApplication entity = (PushApplication)this.entityManager.find(PushApplication.class, (Object)pushApplication.getId());
        this.remove(entity);
    }

    public List<PushApplication> findAllForDeveloper(String loginName) {
        List entities = this.createQuery("select pa from PushApplication pa where pa.developer = :developer").setParameter("developer", (Object)loginName).getResultList();
        return entities;
    }

    public List<String> findAllPushApplicationIDsForDeveloper(String loginName) {
        List ids = this.createQuery("select pa.pushApplicationID from PushApplication pa where pa.developer = :developer").setParameter("developer", (Object)loginName).getResultList();
        return ids;
    }

    public PushApplication findByPushApplicationIDForDeveloper(String pushApplicationID, String loginName) {
        PushApplication entity = this.getSingleResultForQuery(this.createQuery("select pa from PushApplication pa where pa.pushApplicationID = :pushApplicationID and pa.developer = :developer").setParameter("pushApplicationID", (Object)pushApplicationID).setParameter("developer", (Object)loginName));
        return entity;
    }

    public PushApplication findByPushApplicationID(String pushApplicationID) {
        PushApplication entity = this.getSingleResultForQuery(this.createQuery("select pa from PushApplication pa where pa.pushApplicationID = :pushApplicationID").setParameter("pushApplicationID", (Object)pushApplicationID));
        return entity;
    }

    public Map<String, Long> countInstallationsByType(String pushApplicationID) {
        String jpql = "select v.variantID, count(*) from PushApplication pa join pa.{type}Variants v join v.installations i where pushApplicationID = :pushApplicationID group by v.variantID";
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (VariantType variantType : VariantType.values()) {
            String typeQuery = this.parseVariantType("select v.variantID, count(*) from PushApplication pa join pa.{type}Variants v join v.installations i where pushApplicationID = :pushApplicationID group by v.variantID", variantType);
            Query query = this.createQuery(typeQuery).setParameter("pushApplicationID", (Object)pushApplicationID);
            List resultList = query.getResultList();
            long total = 0L;
            for (Object[] objects : resultList) {
                Long value = (Long)objects[1];
                total += value.longValue();
                results.put(String.valueOf(objects[0]), value);
            }
            results.put(variantType.getTypeName(), total);
        }
        return results;
    }

    private String parseVariantType(String jpql, VariantType variantType) {
        String typeName = variantType == VariantType.IOS ? "iOS" : variantType.getTypeName();
        return jpql.replaceAll("\\{type\\}", typeName);
    }

    public long getNumberOfPushApplicationsForDeveloper(String name) {
        return (Long)this.createQuery("select count(pa) from PushApplication pa where pa.developer = :developer").setParameter("developer", (Object)name).getSingleResult();
    }

    public Map<Variant, PushApplication> findByVariantIds(List<String> variantIDs) {
        String jpql = "select v, pa.name, pa.pushApplicationID from PushApplication pa left join pa.{type}Variants v where v.variantID in (:variantIDs)";
        HashMap<Variant, PushApplication> results = new HashMap<Variant, PushApplication>();
        for (VariantType variantType : VariantType.values()) {
            String typeQuery = this.parseVariantType("select v, pa.name, pa.pushApplicationID from PushApplication pa left join pa.{type}Variants v where v.variantID in (:variantIDs)", variantType);
            List resultList = this.createQuery(typeQuery).setParameter("variantIDs", variantIDs).getResultList();
            for (Object[] objects : resultList) {
                PushApplication app = new PushApplication();
                app.setName((String)objects[1]);
                app.setPushApplicationID((String)objects[2]);
                results.put((Variant)objects[0], app);
            }
        }
        return results;
    }

    public PushApplication find(String id) {
        PushApplication entity = (PushApplication)this.entityManager.find(PushApplication.class, (Object)id);
        return entity;
    }

    private PushApplication getSingleResultForQuery(Query query) {
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (PushApplication)result.get(0);
        }
        return null;
    }
}

