/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAInstallationDao
extends JPABaseDao
implements InstallationDao {
    public void create(Installation installation) {
        this.persist(installation);
    }

    public void update(Installation installation) {
        this.merge(installation);
    }

    public void delete(Installation installation) {
        Installation entity = (Installation)this.entityManager.find(Installation.class, (Object)installation.getId());
        this.remove(entity);
    }

    public PageResult<Installation> findInstallationsByVariant(String variantID, String developer, Integer page, Integer pageSize) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Installation.class);
        Root v = query.from(Variant.class);
        Join join = v.join("installations");
        Predicate[] predicates = new Predicate[]{builder.equal((Expression)v.get("variantID"), (Object)variantID), builder.and(new Predicate[]{builder.equal((Expression)v.get("developer"), (Object)developer)})};
        query.where(predicates);
        List result = this.entityManager.createQuery(query.select((Selection)join)).setFirstResult(page * pageSize).setMaxResults(pageSize.intValue()).getResultList();
        CriteriaQuery countQuery = builder.createQuery(Long.class);
        Join join1 = countQuery.from(Variant.class).join("installations");
        countQuery.where(predicates);
        Long count = (Long)this.entityManager.createQuery(countQuery.select((Selection)builder.count((Expression)join1))).getSingleResult();
        return new PageResult(result, count.longValue());
    }

    public Installation findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        Installation entity = this.getSingleResultForQuery(this.createQuery("select installation from Variant  abstractVariant join abstractVariant.installations installation where abstractVariant.variantID = :variantID and installation.deviceToken = :deviceToken").setParameter("variantID", (Object)variantID).setParameter("deviceToken", (Object)deviceToken));
        return entity;
    }

    public List<Installation> findInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        if (deviceTokens == null || deviceTokens.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List entities = this.createQuery("select installation from Variant  abstractVariant join abstractVariant.installations installation where abstractVariant.variantID = :variantID and installation.deviceToken IN :deviceTokens").setParameter("variantID", (Object)variantID).setParameter("deviceTokens", deviceTokens).getResultList();
        return entities;
    }

    public List<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        StringBuilder jpqlString = new StringBuilder("select installation.deviceToken from Variant").append(" abstractVariant join abstractVariant.installations installation where abstractVariant.variantID = :variantID AND installation.enabled = true");
        return this.executeDynamicQuery(jpqlString, variantID, categories, aliases, deviceTypes);
    }

    public List<String> findAllPushEndpointURLsForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        StringBuilder jpqlString = new StringBuilder("select installation.simplePushEndpoint from Variant").append(" abstractVariant join abstractVariant.installations installation where abstractVariant.variantID = :variantID AND installation.enabled = true");
        return this.executeDynamicQuery(jpqlString, variantID, categories, aliases, deviceTypes);
    }

    public long getNumberOfDevicesForVariantIDs(String loginName) {
        return (Long)this.createQuery("select count(installation) from Variant abstractVariant join abstractVariant.installations installation where abstractVariant.variantID IN (select t.variantID from Variant t where t.developer = :developer) ").setParameter("developer", (Object)loginName).getSingleResult();
    }

    public Installation find(String id) {
        Installation entity = (Installation)this.entityManager.find(Installation.class, (Object)id);
        return entity;
    }

    private List<String> executeDynamicQuery(StringBuilder jpqlBaseString, String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (this.isListEmpty(aliases)) {
            jpqlBaseString.append(" and installation.alias IN :aliases");
            parameters.put("aliases", aliases);
        }
        if (this.isListEmpty(deviceTypes)) {
            jpqlBaseString.append(" and installation.deviceType IN :deviceTypes");
            parameters.put("deviceTypes", deviceTypes);
        }
        if (this.isListEmpty(categories)) {
            for (int i = 0; i < categories.size(); ++i) {
                if (i == 0) {
                    jpqlBaseString.append(" and ( :categories" + i + " IN ELEMENTS(installation.categories)");
                } else {
                    jpqlBaseString.append(" OR :categories" + i + " IN ELEMENTS(installation.categories)");
                }
                parameters.put("categories" + i, categories.get(i));
            }
            jpqlBaseString.append(')');
        }
        Query jpql = this.createQuery(jpqlBaseString.toString());
        jpql.setParameter("variantID", (Object)variantID);
        Set paramKeys = parameters.keySet();
        for (String parameterName : paramKeys) {
            jpql.setParameter(parameterName, parameters.get(parameterName));
        }
        return jpql.getResultList();
    }

    private boolean isListEmpty(List list) {
        return list != null && !list.isEmpty();
    }

    private Installation getSingleResultForQuery(Query query) {
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (Installation)result.get(0);
        }
        return null;
    }
}

