/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.server.gcm;

import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.server.Subscriber;
import org.jboss.aerogear.sync.server.gcm.GcmDiffSyncHandler;
import org.jboss.aerogear.sync.server.gcm.GcmMessages;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;

public class GcmSubscriber
implements Subscriber<XMPPConnection> {
    private final String id;
    private final String googleRegistrationId;
    private final XMPPConnection connection;

    public GcmSubscriber(String id, String googleRegistrationId, XMPPConnection connection) {
        this.id = id;
        this.googleRegistrationId = googleRegistrationId;
        this.connection = connection;
    }

    public String clientId() {
        return this.id;
    }

    public XMPPConnection channel() {
        return this.connection;
    }

    public void patched(PatchMessage<?> patchMessage) {
        try {
            this.send(GcmMessages.createJsonMessage(this.googleRegistrationId, "m-" + UUID.randomUUID(), patchMessage.asJson()));
        }
        catch (Exception ex) {
            Logger.getLogger(GcmSubscriber.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void send(String jsonRequest) throws SmackException.NotConnectedException {
        Packet request = new GcmDiffSyncHandler.GcmPacketExtension(jsonRequest).toPacket();
        this.connection.sendPacket(request);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 89 * hash + (this.googleRegistrationId != null ? this.googleRegistrationId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subscriber other = (Subscriber)obj;
        if (this.id == null ? other.clientId() != null : !this.id.equals(other.clientId())) {
            return false;
        }
        return !(this.googleRegistrationId == null ? other.channel() != null : !this.googleRegistrationId.equals(other.channel()));
    }

    public String toString() {
        return "GcmSubscriber{clientId=" + this.id + ", googleRegistrationid=" + this.googleRegistrationId + '}';
    }
}

