/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.server.gcm;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aerogear.sync.Diff;
import org.jboss.aerogear.sync.Document;
import org.jboss.aerogear.sync.Edit;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.diffmatchpatch.JsonMapper;
import org.jboss.aerogear.sync.server.MessageType;
import org.jboss.aerogear.sync.server.ServerSyncEngine;
import org.jboss.aerogear.sync.server.Subscriber;
import org.jboss.aerogear.sync.server.gcm.GcmMessages;
import org.jboss.aerogear.sync.server.gcm.GcmSubscriber;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.xmlpull.v1.XmlPullParser;

public class GcmDiffSyncHandler<T, S extends Edit<? extends Diff>>
implements PacketListener {
    private static final Logger logger = Logger.getLogger(GcmDiffSyncHandler.class.getCanonicalName());
    private static final String GCM_ELEMENT_NAME = "gcm";
    private static final String GCM_NAMESPACE = "google:mobile:data";
    private XMPPConnection connection;
    private final ServerSyncEngine<T, S> syncEngine;
    protected volatile boolean connectionDraining;

    public GcmDiffSyncHandler(ServerSyncEngine<T, S> syncEngine, XMPPConnection connection) {
        this.connection = connection;
        this.syncEngine = syncEngine;
    }

    protected void handleAckReceipt(JsonNode jsonObject) {
        String messageId = jsonObject.get("message_id").asText();
        String from = jsonObject.get("from").asText();
        logger.log(Level.INFO, "handleAckReceipt() from: " + from + ",messageId: " + messageId);
    }

    protected void handleNackReceipt(JsonNode jsonObject) {
        String messageId = jsonObject.get("message_id").asText();
        String from = jsonObject.get("from").asText().replace("\"", "");
        logger.log(Level.INFO, "handleNackReceipt() from: " + from + ",messageId: " + messageId);
    }

    protected void handleControlMessage(JsonNode jsonObject) {
        logger.log(Level.INFO, "handleControlMessage(): " + jsonObject);
        String controlType = jsonObject.get("control_type").asText();
        if ("CONNECTION_DRAINING".equals(controlType)) {
            this.connectionDraining = true;
        } else {
            logger.log(Level.INFO, "Unrecognized control type: %s. This could happen if new features are added to the CCS protocol.", controlType);
        }
    }

    protected static String createJsonAck(String to, String messageId) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("message_type", "ack");
        message.put("to", to);
        message.put("message_id", messageId);
        return JSONValue.toJSONString(message);
    }

    public void processPacket(Packet packet) {
        logger.log(Level.INFO, "Received: " + packet.toXML());
        Message incomingMessage = (Message)packet;
        GcmPacketExtension gcmPacket = (GcmPacketExtension)incomingMessage.getExtension(GCM_NAMESPACE);
        String body = gcmPacket.getJson();
        try {
            JsonNode jsonObject = JsonMapper.asJsonNode((String)body);
            JsonNode messageType = jsonObject.get("message_type");
            if (messageType == null) {
                this.messageReceived(jsonObject);
                String messageId = jsonObject.get("message_id").asText();
                String clientId = jsonObject.get("from").asText().replace("\"", "");
                String ack = GcmDiffSyncHandler.createJsonAck(clientId, messageId);
                this.send(ack);
            } else if ("ack".equals(messageType.asText())) {
                this.handleAckReceipt(jsonObject);
            } else if ("nack".equals(messageType.asText())) {
                this.handleNackReceipt(jsonObject);
            } else if ("control".equals(messageType.asText())) {
                this.handleControlMessage(jsonObject);
            } else {
                logger.log(Level.WARNING, "Unrecognized message type: " + messageType.asText());
            }
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "Error parsing JSON " + body, e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to process packet", e);
        }
    }

    protected void messageReceived(JsonNode json) throws Exception {
        JsonNode syncMessage = JsonMapper.asJsonNode((String)json.get("data").get("message").asText());
        logger.info("Doc:" + json);
        String googleRegistrationId = json.get("from").asText();
        String diffsyncClientId = GcmDiffSyncHandler.clientIdFromJson(syncMessage);
        switch (MessageType.from((String)syncMessage.get("msgType").asText())) {
            case ADD: {
                Document doc = this.syncEngine.documentFromJson(syncMessage);
                PatchMessage<S> patchMessage = this.addSubscriber(doc, diffsyncClientId, googleRegistrationId);
                this.send(GcmMessages.createJsonMessage(googleRegistrationId, "m-" + UUID.randomUUID(), patchMessage.asJson()));
                break;
            }
            case PATCH: {
                PatchMessage clientPatchMessage = this.syncEngine.patchMessageFromJson(syncMessage.toString());
                logger.info("Client Edits=" + clientPatchMessage);
                this.checkForReconnect(clientPatchMessage.documentId(), googleRegistrationId, diffsyncClientId);
                this.patch(clientPatchMessage);
                break;
            }
            case DETACH: {
                break;
            }
        }
    }

    private PatchMessage<S> addSubscriber(Document<T> document, String clientId, String googleRegistrationId) {
        GcmSubscriber gcmSubscriber = new GcmSubscriber(clientId, googleRegistrationId, this.connection);
        return this.syncEngine.addSubscriber((Subscriber)gcmSubscriber, document);
    }

    private void patch(PatchMessage<S> patchMessage) {
        this.syncEngine.notifySubscribers(this.syncEngine.patch(patchMessage));
    }

    protected void send(String jsonRequest) throws SmackException.NotConnectedException {
        Packet request = new GcmPacketExtension(jsonRequest).toPacket();
        this.connection.sendPacket(request);
    }

    private void checkForReconnect(String documentId, String registrationId, String clientId) {
        logger.info("Reconnected client [" + registrationId + "]. Adding as listener.");
        GcmSubscriber gcmSubscriber = new GcmSubscriber(clientId, registrationId, this.connection);
        this.syncEngine.connectSubscriber((Subscriber)gcmSubscriber, documentId);
    }

    private static String clientIdFromJson(JsonNode syncMessage) {
        JsonNode clientId = syncMessage.get("clientId");
        String content = null;
        if (clientId != null && !clientId.isNull()) {
            content = clientId.asText();
        }
        return content;
    }

    static {
        ProviderManager.addExtensionProvider((String)GCM_ELEMENT_NAME, (String)GCM_NAMESPACE, (Object)new PacketExtensionProvider(){

            public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
                String json = parser.nextText();
                return new GcmPacketExtension(json);
            }
        });
    }

    static final class GcmPacketExtension
    extends DefaultPacketExtension {
        private final String json;

        GcmPacketExtension(String json) {
            super(GcmDiffSyncHandler.GCM_ELEMENT_NAME, GcmDiffSyncHandler.GCM_NAMESPACE);
            this.json = json;
        }

        public String getJson() {
            return this.json;
        }

        public String toXML() {
            return String.format("<%s xmlns=\"%s\">%s</%s>", GcmDiffSyncHandler.GCM_ELEMENT_NAME, GcmDiffSyncHandler.GCM_NAMESPACE, StringUtils.escapeForXML((String)this.json), GcmDiffSyncHandler.GCM_ELEMENT_NAME);
        }

        public Packet toPacket() {
            Message message = new Message();
            message.addExtension((PacketExtension)this);
            return message;
        }
    }
}

