/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.adm;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import javax.net.ssl.HttpsURLConnection;
import org.jboss.aerogear.adm.internal.Utilities;

public class TokenService {
    public String getAuthToken(String clientId, String clientSecret) throws Exception {
        String body = this.buildBody(clientId, clientSecret);
        HttpsURLConnection con = this.post(body);
        String responseContent = Utilities.parseResponse(con.getInputStream());
        String accessToken = Utilities.getStringFromJson(responseContent, "access_token");
        return accessToken;
    }

    private String buildBody(String clientId, String clientSecret) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append("grant_type=").append(URLEncoder.encode("client_credentials", "UTF-8")).append("&").append("scope=").append(URLEncoder.encode("messaging:push", "UTF-8")).append("&").append("client_id=").append(URLEncoder.encode(clientId, "UTF-8")).append("&").append("client_secret=").append(URLEncoder.encode(clientSecret, "UTF-8"));
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection post(String payload) throws Exception {
        URL authUrl = new URL("https://api.amazon.com/auth/O2/token");
        HttpsURLConnection conn = Utilities.getHttpsURLConnection(authUrl);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("charset", "UTF-8");
        conn.setRequestMethod("POST");
        OutputStream out = null;
        byte[] bytes = payload.getBytes(Utilities.UTF_8_CHARSET);
        try {
            out = conn.getOutputStream();
            out.write(bytes);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }
}

