/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.adm.internal;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import javax.net.ssl.HttpsURLConnection;

public final class Utilities {
    public static final String APPLICATION_JSON = "application/json";
    public static final String AMAZON_TYPE_VERSION = "com.amazon.device.messaging.ADMMessage@1.0";
    public static final String AMAZON_ACCEPT_TYPE = "com.amazon.device.messaging.ADMSendResult@1.0";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String ADM_URL_TEMPLATE = "https://api.amazon.com/messaging/registrations/%1$s/messages";
    public static final String HTTPS_API_AMAZON_COM_AUTH_O2_TOKEN = "https://api.amazon.com/auth/O2/token";
    public static final String UTF_8 = "UTF-8";
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String MESSAGING_PUSH = "messaging:push";

    private Utilities() {
    }

    public static HttpsURLConnection getHttpsURLConnection(URL url) throws Exception {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseResponse(InputStream in) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    public static String getStringFromJson(String jsonString, String property) {
        Gson gson = new Gson();
        JsonObject parsedObject = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        return parsedObject.get(property).getAsString();
    }
}

