/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.vertx;

import org.jboss.aerogear.simplepush.server.DefaultSimplePushConfig;
import org.jboss.aerogear.simplepush.server.DefaultSimplePushServer;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.jboss.aerogear.simplepush.server.SimplePushServerConfig;
import org.jboss.aerogear.simplepush.server.datastore.DataStore;
import org.jboss.aerogear.simplepush.server.datastore.InMemoryDataStore;
import org.jboss.aerogear.simplepush.vertx.HttpNotificationHandler;
import org.jboss.aerogear.simplepush.vertx.SimplePushServerHandler;
import org.jboss.aerogear.simplepush.vertx.UserAgentReaper;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.sockjs.SockJSServer;
import org.vertx.java.platform.Verticle;

public class VertxSimplePushServer
extends Verticle {
    public static final String WRITE_HANDLER_MAP = "simplepush.writehandler.map";
    public static final String LAST_ACCESSED_MAP = "simplepush.lastaccessed.map";
    public static final String USER_AGENT_REMOVER = "simplepush.useragent.remover";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 7777;

    public void start() {
        SimplePushServerConfig config = this.fromConfig(this.container.config());
        InMemoryDataStore datastore = new InMemoryDataStore();
        byte[] privateKey = DefaultSimplePushServer.generateAndStorePrivateKey((DataStore)datastore, (SimplePushServerConfig)config);
        DefaultSimplePushServer simplePushServer = new DefaultSimplePushServer((DataStore)datastore, config, privateKey);
        HttpServer httpServer = this.vertx.createHttpServer();
        this.setupHttpNotificationHandler(httpServer, (SimplePushServer)simplePushServer);
        this.setupSimplePushSockJSServer(httpServer, (SimplePushServer)simplePushServer);
        this.startHttpServer(httpServer);
        this.setupUserAgentReaperJob((SimplePushServer)simplePushServer);
    }

    private SimplePushServerConfig fromConfig(JsonObject config) {
        return DefaultSimplePushConfig.create().ackInterval(config.getLong("ackInterval")).endpointPrefix(config.getString("endpointUrlPrefix")).password(config.getString("password", "changeme!!!")).userAgentReaperTimeout(config.getLong("userAgentReaperTimeout")).build();
    }

    private void startHttpServer(HttpServer httpServer) {
        String host = this.container.config().getString("host", DEFAULT_HOST);
        int port = this.container.config().getInteger("port", 7777);
        httpServer.listen(port, host);
        this.container.logger().info((Object)("Started VertxSimplePushServer on host [" + host + "] port [" + port + "]"));
    }

    private void setupHttpNotificationHandler(HttpServer httpServer, SimplePushServer simplePushServer) {
        RouteMatcher rm = new RouteMatcher();
        String endpointUrlPrefix = simplePushServer.config().endpointPrefix();
        rm.put(endpointUrlPrefix + "/:endpoint", (Handler)new HttpNotificationHandler(simplePushServer, this.vertx, this.container));
        httpServer.requestHandler((Handler)rm);
    }

    private void setupSimplePushSockJSServer(HttpServer httpServer, SimplePushServer simplePushServer) {
        JsonObject appConfig = new JsonObject().putString("prefix", "/simplepush");
        SockJSServer sockJSServer = this.vertx.createSockJSServer(httpServer);
        sockJSServer.installApp(appConfig, (Handler)new SimplePushServerHandler(simplePushServer, this.vertx, this.container));
    }

    private void setupUserAgentReaperJob(final SimplePushServer simplePushServer) {
        final Logger logger = this.container.logger();
        this.vertx.eventBus().registerHandler(USER_AGENT_REMOVER, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> msg) {
                String uaid = (String)msg.body();
                simplePushServer.removeAllChannels(uaid);
                logger.info((Object)("Removed all channels for [" + uaid + "] due to inactivity"));
            }
        });
        this.container.deployWorkerVerticle(UserAgentReaper.class.getName(), this.container.config());
    }
}

