/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.protocol.impl;

import java.util.Collections;
import java.util.Set;
import org.jboss.aerogear.simplepush.protocol.HelloMessage;
import org.jboss.aerogear.simplepush.protocol.MessageType;
import org.jboss.aerogear.simplepush.util.UUIDUtil;

public class HelloMessageImpl
implements HelloMessage {
    private final String uaid;
    private final Set<String> channelIds;

    public HelloMessageImpl() {
        this("");
    }

    public HelloMessageImpl(String uaid) {
        this(uaid, Collections.emptySet());
    }

    public HelloMessageImpl(String uaid, Set<String> channelIds) {
        if (UUIDUtil.nullOrEmpty((String)uaid)) {
            this.uaid = UUIDUtil.newUAID();
            this.channelIds = Collections.emptySet();
        } else {
            this.channelIds = channelIds;
            this.uaid = UUIDUtil.fromString((String)uaid);
        }
    }

    @Override
    public String getUAID() {
        return this.uaid;
    }

    @Override
    public Set<String> getChannelIds() {
        return Collections.unmodifiableSet(this.channelIds);
    }

    @Override
    public MessageType.Type getMessageType() {
        return MessageType.Type.HELLO;
    }

    public String toString() {
        return "HandshakeImpl[messageType=" + (Object)((Object)this.getMessageType()) + ", uaid=" + this.uaid + ", channelIds=" + this.channelIds + "]";
    }
}

