/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.protocol.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aerogear.simplepush.protocol.Ack;
import org.jboss.aerogear.simplepush.protocol.MessageType;
import org.jboss.aerogear.simplepush.protocol.NotificationMessage;
import org.jboss.aerogear.simplepush.util.ArgumentUtil;

public class NotificationMessageImpl
implements NotificationMessage {
    private final Set<Ack> acks;

    public NotificationMessageImpl(Ack ack) {
        this(new HashSet<Ack>(Arrays.asList(ack)));
    }

    public NotificationMessageImpl(Set<Ack> acks) {
        ArgumentUtil.checkNotNullAndNotEmpty(acks, (String)"acks");
        this.acks = acks;
    }

    @Override
    public MessageType.Type getMessageType() {
        return MessageType.Type.NOTIFICATION;
    }

    @Override
    public Set<Ack> getAcks() {
        return Collections.unmodifiableSet(this.acks);
    }

    public String toString() {
        return "NotificationImpl[messageType=" + (Object)((Object)this.getMessageType()) + ", acks=" + this.acks + "]";
    }
}

