/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.web.filter;

import java.io.IOException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.security.token.service.TokenService;
import org.jboss.aerogear.security.web.filter.PasswordHandlerConfig;

public class PasswordHandler
implements Filter {
    public static final String TOKEN_ID_PARAM = "id";
    private final TokenService tokenService;

    @Inject
    public PasswordHandler(Instance<TokenService> tokenService) {
        this.tokenService = tokenService.isUnsatisfied() ? this.defaultSecurityProvider() : (TokenService)tokenService.get();
    }

    public void init(FilterConfig config) throws ServletException {
        PasswordHandlerConfig.loadFilterConfig(config);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String tokenId = httpServletRequest.getParameter(TOKEN_ID_PARAM);
        String method = httpServletRequest.getMethod();
        if (!this.tokenService.isValid(tokenId) || !method.equalsIgnoreCase("GET")) {
            httpServletResponse.sendError(404, "Not found");
            return;
        }
        this.redirectPage(httpServletRequest, httpServletResponse);
    }

    private void redirectPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletRequest.getRequestDispatcher(PasswordHandlerConfig.getRedirectPage()).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
    }

    private TokenService defaultSecurityProvider() {
        return new TokenService(){

            @Override
            public void destroy(String id) {
            }

            @Override
            public boolean isValid(String id) {
                return false;
            }

            @Override
            public String generate(String email) {
                return null;
            }
        };
    }
}

