/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.util;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.jboss.aerogear.controller.router.MediaType;
import org.jboss.aerogear.controller.router.RequestMethod;

public class RequestUtils {
    private static final Pattern PATH_SEGMENT_PATTERN = Pattern.compile("/([^/]+)");
    private static final Pattern PATH_PLACEHOLDER_PATTERN = Pattern.compile("/\\{?([^/}?]+)\\}?");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([a-zA-Z]*)\\}");
    private static final Pattern PATH_PATTERN = Pattern.compile("/(?:([^/]+))");
    private static final String MEDIA_RANGE = "(\\*|\\w)+";
    private static final Pattern ACCEPT_HEADER_PATTERN = Pattern.compile("((\\*|\\w)+/(\\*|\\w)+)");

    private RequestUtils() {
    }

    public static String extractPath(HttpServletRequest request) {
        String contextPath = request.getServletContext().getContextPath();
        return request.getRequestURI().substring(contextPath.length());
    }

    public static RequestMethod extractMethod(HttpServletRequest httpServletRequest) {
        return RequestMethod.valueOf(httpServletRequest.getMethod());
    }

    public static Set<String> extractAcceptHeader(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> acceptHeaders = new LinkedHashSet<String>();
        Matcher m = ACCEPT_HEADER_PATTERN.matcher(acceptHeader);
        while (m.find()) {
            acceptHeaders.add(m.group(1));
        }
        return acceptHeaders;
    }

    public static Map<Integer, String> extractPathSegments(String path) {
        Matcher requestMatcher = PATH_PLACEHOLDER_PATTERN.matcher(path);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 0;
        while (requestMatcher.find()) {
            map.put(i, requestMatcher.group(1));
            ++i;
        }
        return map;
    }

    public static Map<String, Integer> extractPathVariableNames(String path) {
        Matcher requestMatcher = PATH_SEGMENT_PATTERN.matcher(path);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int i = 0;
        while (requestMatcher.find()) {
            String segment = requestMatcher.group(1);
            if (segment.startsWith("{")) {
                map.put(RequestUtils.trimPlaceHolder(segment), i);
            }
            ++i;
        }
        return map;
    }

    private static String trimPlaceHolder(String str) {
        return str.substring(1, str.length() - 1);
    }

    public static Map<String, String> mapPathParams(String requestPath, String configPath) {
        Map<Integer, String> pathElementsMap = RequestUtils.extractPathSegments(requestPath);
        Map<String, Integer> pathVariableNameMap = RequestUtils.extractPathVariableNames(configPath);
        HashMap<String, String> params = new HashMap<String, String>();
        Matcher configMatcher = PLACEHOLDER_PATTERN.matcher(configPath);
        while (configMatcher.find()) {
            String paramName = configMatcher.group(1);
            String value = pathElementsMap.get(pathVariableNameMap.get(paramName));
            params.put(paramName, value);
        }
        return params;
    }

    public static boolean acceptsMediaType(Set<String> acceptHeaders, Set<MediaType> produces) {
        if (acceptHeaders.isEmpty() || acceptHeaders.contains("*/*")) {
            return true;
        }
        return RequestUtils.getAcceptedMediaType(acceptHeaders, produces).isPresent();
    }

    public static Optional<MediaType> getAcceptedMediaType(Set<String> acceptHeaders, Set<MediaType> produces) {
        for (String acceptHeader : acceptHeaders) {
            for (MediaType mediaType : produces) {
                if (acceptHeader.equals(mediaType.getType())) {
                    return Optional.of((Object)mediaType);
                }
                String[] types = acceptHeader.split("/");
                if (!mediaType.getType().startsWith(types[0]) || !types[1].equals("*")) continue;
                return Optional.of((Object)mediaType);
            }
        }
        return Optional.absent();
    }

    public static Set<String> extractPlaceHolders(String str) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(str);
        HashSet<String> params = new HashSet<String>();
        while (matcher.find()) {
            params.add(matcher.group(1));
        }
        return params;
    }

    public static String injectParamValues(String str, Map<String, Object> map) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, String.valueOf(map.get(matcher.group(1))));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean segmentsMatch(String placeHolderPath, String realPath) {
        List<String> placeholderSegments = RequestUtils.pathSegements(placeHolderPath);
        List<String> realPathSegments = RequestUtils.pathSegements(realPath);
        if (placeholderSegments.size() != realPathSegments.size()) {
            return false;
        }
        int segments = placeholderSegments.size();
        for (int i = 0; i < segments; ++i) {
            String placeholderSegment = placeholderSegments.get(i);
            String realPathSegment = realPathSegments.get(i);
            if (!(placeholderSegment.charAt(0) == '{' ? realPathSegment == null || realPathSegment.equals("") : !placeholderSegment.equals(realPathSegment))) continue;
            return false;
        }
        return true;
    }

    public static List<String> pathSegements(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        Matcher m = PATH_PATTERN.matcher(path);
        while (m.find()) {
            segments.add(m.group(1));
        }
        return segments;
    }
}

