/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.controller.router.rest.pagination.Links;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationProperties;
import org.jboss.aerogear.controller.router.rest.pagination.RequestPathParser;
import org.jboss.aerogear.controller.router.rest.pagination.WebLinking;

public class PaginationMetadata {
    public static final String DEFAULT_HEADER_PREFIX = "AG-";
    private final Links links;
    private final WebLinking webLinking;
    private final PaginationProperties params;
    private final Optional<String> headerPrefix;

    public PaginationMetadata(PaginationProperties paging, RequestPathParser requestPathParser) {
        this(paging, requestPathParser, (Optional<String>)Optional.absent());
    }

    public PaginationMetadata(PaginationProperties paging, RequestPathParser requestPathParser, String headerPrefix) {
        this(paging, requestPathParser, (Optional<String>)Optional.of((Object)headerPrefix));
    }

    private PaginationMetadata(PaginationProperties params, RequestPathParser requestPathParser, Optional<String> headerPrefix) {
        this.params = params;
        this.headerPrefix = headerPrefix;
        this.links = new Links(requestPathParser, params);
        this.webLinking = new WebLinking(this.links);
    }

    public Links getLinks() {
        return this.links;
    }

    public Map<String, String> getHeaders(int resultsSize) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.headerPrefix.isPresent()) {
            if (!this.firstpage()) {
                headers.put((String)this.headerPrefix.get() + "Links-Previous", this.links.getPrevious());
            }
            if (this.fullpage(resultsSize)) {
                headers.put((String)this.headerPrefix.get() + "Links-Next", this.links.getNext());
            }
        } else if (this.firstpage() && this.fullpage(resultsSize)) {
            headers.put(this.webLinking.getLinkHeaderName(), this.webLinking.getNext());
        } else if (!this.firstpage() && !this.fullpage(resultsSize)) {
            headers.put(this.webLinking.getLinkHeaderName(), this.webLinking.getPrevious());
        } else if (this.fullpage(resultsSize)) {
            headers.put(this.webLinking.getLinkHeaderName(), this.webLinking.getLinkHeaders());
        }
        return headers;
    }

    private boolean firstpage() {
        return this.params.isFirstOffset();
    }

    private boolean fullpage(int results) {
        return results == this.params.limit();
    }

    public WebLinking getWebLinking() {
        return this.webLinking;
    }

    public String toString() {
        return "PagingMetadata[params=" + this.params + ", links=" + this.links + ", headerPrefix=" + this.headerPrefix + ", webLinking=" + this.webLinking + "]";
    }
}

