/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.rest.pagination.Paginated;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationMetadata;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationProperties;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationStrategy;
import org.jboss.aerogear.controller.router.rest.pagination.RequestPathParser;

public abstract class AbstractPaginationStrategy
implements PaginationStrategy {
    public abstract void setResponseHeaders(PaginationMetadata var1, HttpServletResponse var2, int var3);

    @Override
    public PaginationInfo createPaginationInfo(RouteContext routeContext, Map<String, Object> args) {
        Paginated paginated = routeContext.getRoute().getTargetMethod().getAnnotation(Paginated.class);
        return PaginationInfo.offset(paginated.offsetParamName(), this.argAsInt(args, paginated.offsetParamName())).limit(paginated.limitParamName(), this.argAsInt(args, paginated.limitParamName())).customHeadersPrefix(paginated.customHeadersPrefix()).webLinking(paginated.webLinking()).build();
    }

    @Override
    public Object[] preInvocation(PaginationInfo paginationInfo, Map<String, Object> arguments) {
        return this.merge(paginationInfo, arguments).toArray();
    }

    private List<Object> merge(PaginationInfo paginationInfo, Map<String, Object> arguments) {
        ArrayList<Object> methodArguments = new ArrayList<Object>();
        arguments.remove(paginationInfo.getOffsetParamName());
        arguments.remove(paginationInfo.getLimitParamName());
        methodArguments.add(paginationInfo);
        methodArguments.addAll(arguments.values());
        return methodArguments;
    }

    @Override
    public Object postInvocation(Collection<?> results, RouteContext routeContext, PaginationInfo pagingInfo) {
        PaginationMetadata pagingMetadata = this.createMetadata(routeContext, pagingInfo);
        this.setResponseHeaders(pagingMetadata, routeContext.getResponse(), results.size());
        return results;
    }

    private PaginationMetadata createMetadata(RouteContext routeContext, PaginationInfo pagingInfo) {
        RequestPathParser requestPathParser = new RequestPathParser(pagingInfo, this.getResourcePath(routeContext));
        PaginationProperties pagingProperties = new PaginationProperties(pagingInfo.getOffset(), pagingInfo.getLimit());
        if (pagingInfo.webLinking()) {
            return new PaginationMetadata(pagingProperties, requestPathParser);
        }
        return new PaginationMetadata(pagingProperties, requestPathParser, (String)pagingInfo.getHeaderPrefix().get());
    }

    private String getResourcePath(RouteContext routeContext) {
        HttpServletRequest request = routeContext.getRequest();
        String resourcePath = request.getRequestURL().toString() + "?" + routeContext.getRequest().getQueryString();
        if (resourcePath.startsWith("/")) {
            return resourcePath.substring(1);
        }
        return resourcePath;
    }

    private int argAsInt(Map<String, Object> args, String argName) {
        return Integer.valueOf((String)args.get(argName));
    }
}

