/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.decorators;

import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletException;
import org.jboss.aerogear.controller.router.InvocationResult;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.spi.SecurityProvider;

@Decorator
public class SecurityHandler
implements RouteProcessor {
    private final RouteProcessor delegate;
    private final SecurityProvider securityProvider;

    @Inject
    public SecurityHandler(@Delegate RouteProcessor delegate, Instance<SecurityProvider> securityProviders) {
        this.delegate = delegate;
        this.securityProvider = securityProviders.isUnsatisfied() ? this.defaultSecurityProvider() : (SecurityProvider)securityProviders.get();
    }

    @Override
    public InvocationResult process(RouteContext routeContext) throws Exception {
        Route route = routeContext.getRoute();
        if (route.isSecured()) {
            this.securityProvider.isRouteAllowed(route);
        }
        return this.delegate.process(routeContext);
    }

    private SecurityProvider defaultSecurityProvider() {
        return new SecurityProvider(){

            @Override
            public void isRouteAllowed(Route route) throws ServletException {
            }
        };
    }
}

