/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.aerogear.controller.router.ControllerFactory;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;

public class EndpointInvoker {
    private final BeanManager beanManager;
    private final ControllerFactory controllerFactory;

    @Inject
    public EndpointInvoker(ControllerFactory controllerFactory, BeanManager beanManager) {
        this.controllerFactory = controllerFactory;
        this.beanManager = beanManager;
    }

    public Object invoke(RouteContext routeContext, Object[] args) throws Exception {
        Route route = routeContext.getRoute();
        return route.getTargetMethod().invoke(this.getController(route), args);
    }

    private Object getController(Route route) {
        return this.controllerFactory.createController(route.getTargetClass(), this.beanManager);
    }
}

