/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.decorators.cors;

import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.router.RequestMethod;
import org.jboss.aerogear.controller.router.Router;
import org.jboss.aerogear.controller.router.decorators.cors.Cors;
import org.jboss.aerogear.controller.router.decorators.cors.CorsConfig;
import org.jboss.aerogear.controller.router.decorators.cors.CorsConfiguration;
import org.jboss.aerogear.controller.util.RequestUtils;

@Decorator
public class CorsHandler
implements Router {
    private final Router delegate;
    private final CorsConfiguration corsConfig;

    @Inject
    public CorsHandler(@Delegate Router delegate, Instance<CorsConfiguration> corsConfigInstance) {
        this.delegate = delegate;
        this.corsConfig = corsConfigInstance.isUnsatisfied() ? CorsConfig.defaultConfig() : (CorsConfiguration)corsConfigInstance.get();
    }

    @Override
    public boolean hasRouteFor(HttpServletRequest request) {
        if (this.corsConfig.isCorsSupportEnabled() && RequestUtils.extractMethod(request).equals((Object)RequestMethod.OPTIONS)) {
            return true;
        }
        return this.delegate.hasRouteFor(request);
    }

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException {
        Cors cors = new Cors(this.corsConfig, request);
        if (cors.canHandleRequest()) {
            if (cors.isPreflightRequest()) {
                this.handlePreflight(cors, response);
                return;
            }
            this.handleSimpleRequest(cors, response);
        }
        this.delegate.dispatch(request, response, chain);
    }

    private void handleSimpleRequest(Cors cors, HttpServletResponse response) {
        cors.setAllowCredentials(response).setOrigin(response).setExposeHeaders(response);
    }

    private void handlePreflight(Cors cors, HttpServletResponse response) {
        response.setStatus(200);
        if (!cors.isRequestMethodValid()) {
            AeroGearLogger.LOGGER.badCorsRequestMethod(cors.getRequestMethod(), cors.getAllowedRequestMethods());
            return;
        }
        if (cors.hasRequestHeaders()) {
            if (!cors.areRequestHeadersValid()) {
                AeroGearLogger.LOGGER.badCorsRequestHeaders(cors.getRequestHeaders(), cors.getAllowedRequestHeaders());
                return;
            }
            cors.setAllowHeaders(response);
        }
        cors.setAllowMethods(response).setAllowCredentials(response).setOrigin(response).setMaxAge(response);
    }
}

