/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.util;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jboss.aerogear.controller.router.RequestMethod;

public class RequestUtils {
    private RequestUtils() {
    }

    public static String extractPath(HttpServletRequest request) {
        String contextPath = request.getServletContext().getContextPath();
        return request.getRequestURI().substring(contextPath.length());
    }

    public static RequestMethod extractMethod(HttpServletRequest httpServletRequest) {
        return RequestMethod.valueOf(httpServletRequest.getMethod());
    }

    public static Set<String> extractAcceptHeader(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> acceptHeaders = new LinkedHashSet<String>();
        for (String header : Splitter.on((char)',').trimResults().split((CharSequence)acceptHeader)) {
            acceptHeaders.add(header);
        }
        return acceptHeaders;
    }
}

