/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.util;

import br.com.caelum.iogi.Iogi;
import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.spi.DependencyProvider;
import br.com.caelum.iogi.spi.LocaleProvider;
import br.com.caelum.iogi.util.DefaultLocaleProvider;
import br.com.caelum.iogi.util.NullDependencyProvider;
import com.google.common.base.Optional;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.log.LoggerMessages;
import org.jboss.aerogear.controller.router.Consumer;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.parameter.RequestParameter;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;
import org.jboss.aerogear.controller.util.StringUtils;

public class ParameterExtractor {
    private static final Iogi IOGI = new Iogi((DependencyProvider)new NullDependencyProvider(), (LocaleProvider)new DefaultLocaleProvider());

    public static Map<String, Object> extractArguments(RouteContext routeContext, Map<String, Consumer> consumers) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        for (org.jboss.aerogear.controller.router.parameter.Parameter<?> parameter : routeContext.getRoute().getParameters()) {
            switch (parameter.getParameterType()) {
                case ENTITY: {
                    if (PaginationInfo.class.isAssignableFrom(parameter.getType()) || ParameterExtractor.addIfPresent(ParameterExtractor.extractIogiParam(routeContext), "entity", args)) break;
                    args.put("entity", ParameterExtractor.extractBody(routeContext, parameter, consumers));
                    break;
                }
                case REQUEST: {
                    RequestParameter requestParameter = (RequestParameter)parameter;
                    if (ParameterExtractor.addIfPresent(ParameterExtractor.extractParam(routeContext, requestParameter), requestParameter.getName(), args) || ParameterExtractor.addIfPresent(ParameterExtractor.extractHeaderParam(routeContext, requestParameter), requestParameter.getName(), args) || ParameterExtractor.addIfPresent(ParameterExtractor.extractCookieParam(routeContext, requestParameter), requestParameter.getName(), args) || ParameterExtractor.addIfPresent(requestParameter.getDefaultValue(), requestParameter.getName(), args) || ParameterExtractor.addIfPresent(ParameterExtractor.extractPathParam(routeContext), requestParameter.getName(), args)) break;
                    throw LoggerMessages.MESSAGES.missingParameterInRequest(requestParameter.getName());
                }
            }
        }
        return args;
    }

    private static Object extractBody(RouteContext routeContext, org.jboss.aerogear.controller.router.parameter.Parameter<?> parameter, Map<String, Consumer> consumers) {
        Set<String> mediaTypes = routeContext.getRoute().consumes();
        for (String mediaType : mediaTypes) {
            Consumer consumer = consumers.get(mediaType);
            if (consumer == null) continue;
            return consumer.unmarshall(routeContext.getRequest(), parameter.getType());
        }
        throw LoggerMessages.MESSAGES.noConsumerForMediaType(parameter, consumers.values(), mediaTypes);
    }

    public static Optional<String> extractPathParam(RouteContext routeContext) {
        String requestPath = routeContext.getRequestPath();
        int paramOffset = routeContext.getRoute().getPath().indexOf(123);
        if (paramOffset != -1 && paramOffset < requestPath.length()) {
            return Optional.of((Object)requestPath.subSequence(paramOffset, requestPath.length()).toString());
        }
        return Optional.absent();
    }

    public static Optional<?> extractIogiParam(RouteContext routeContext) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        for (Map.Entry entry : routeContext.getRequest().getParameterMap().entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value.length == 1) {
                parameters.add(new Parameter((String)entry.getKey(), value[0]));
                continue;
            }
            AeroGearLogger.LOGGER.multivaluedParamsUnsupported();
        }
        if (!parameters.isEmpty()) {
            Class<?>[] parameterTypes = routeContext.getRoute().getTargetMethod().getParameterTypes();
            Class<?> parameterType = parameterTypes[0];
            Target target = Target.create(parameterType, (String)StringUtils.downCaseFirst(parameterType.getSimpleName()));
            return Optional.fromNullable((Object)IOGI.instantiate(target, parameters.toArray(new Parameter[parameters.size()])));
        }
        return Optional.absent();
    }

    private static boolean addIfPresent(Optional<?> op, String paramName, Map<String, Object> args) {
        if (op.isPresent()) {
            args.put(paramName, op.get());
            return true;
        }
        return false;
    }

    private static Optional<?> extractHeaderParam(RouteContext routeContext, RequestParameter<?> parameter) {
        return Optional.fromNullable((Object)routeContext.getRequest().getHeader(parameter.getName()));
    }

    private static Optional<?> extractCookieParam(RouteContext routeContext, RequestParameter<?> parameter) {
        Cookie[] cookies = routeContext.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(parameter.getName())) continue;
                return Optional.fromNullable((Object)cookie.getValue());
            }
        }
        return Optional.absent();
    }

    private static Optional<?> extractParam(RouteContext routeContext, RequestParameter<?> parameter) {
        String[] values = (String[])routeContext.getRequest().getParameterMap().get(parameter.getName());
        if (values != null) {
            if (values.length == 1) {
                return Optional.of((Object)values[0]);
            }
            throw LoggerMessages.MESSAGES.multivaluedParamsUnsupported(parameter.getName());
        }
        return Optional.absent();
    }
}

