/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.security;

import android.content.Context;
import android.content.SharedPreferences;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.crypto.CryptoBox;
import org.jboss.aerogear.crypto.RandomUtils;
import org.jboss.aerogear.crypto.encoders.Hex;

public abstract class AbstractEncryptionService
implements EncryptionService {
    private static final String APPLICATION_IV_KEY = "applicationIV";
    private static final String TAG = AbstractEncryptionService.class.getSimpleName();
    private static final int DEFAULT_IV_LENGTH = 1024;
    protected static final byte[] INSTANCE_IV = RandomUtils.randomBytes((int)1024);
    protected final byte[] applicationIV;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEncryptionService(Context appContext) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            SharedPreferences preferences = appContext.getApplicationContext().getSharedPreferences(TAG, 0);
            if (preferences.contains(APPLICATION_IV_KEY)) {
                this.applicationIV = new Hex().decode(preferences.getString(APPLICATION_IV_KEY, ""));
            } else {
                SharedPreferences.Editor editor = preferences.edit();
                this.applicationIV = INSTANCE_IV;
                editor.putString(APPLICATION_IV_KEY, new Hex().encode(this.applicationIV));
                editor.commit();
            }
        }
    }

    protected abstract CryptoBox getCryptoInstance();

    @Override
    public byte[] decrypt(byte[] message) {
        return this.decrypt(this.applicationIV, message);
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] message) {
        return this.getCryptoInstance().decrypt(iv, message);
    }

    @Override
    public byte[] encrypt(byte[] message) {
        return this.encrypt(this.applicationIV, message);
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] message) {
        return this.getCryptoInstance().encrypt(iv, message);
    }
}

