/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.test.loader;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.test.runner.AndroidJUnit4;
import junit.framework.Assert;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.callback.AbstractActivityCallback;
import org.jboss.aerogear.android.pipe.callback.AbstractFragmentCallback;
import org.jboss.aerogear.android.pipe.loader.AbstractPipeLoader;
import org.jboss.aerogear.android.pipe.loader.LoaderAdapter;
import org.jboss.aerogear.android.pipe.loader.ReadLoader;
import org.jboss.aerogear.android.pipe.test.MainActivity;
import org.jboss.aerogear.android.pipe.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.pipe.test.util.UnitTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=AndroidJUnit4.class)
public class CallbackTest
extends PatchedActivityInstrumentationTestCase {
    public CallbackTest() {
        super(MainActivity.class);
    }

    @Test
    public void testPassModernFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        LoaderAdapter adapter = new LoaderAdapter(fragment, (Context)this.getActivity(), (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        Assert.assertTrue((boolean)fragmentCallback.successCalled);
        Assert.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    @Test
    public void testFailModernFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        LoaderAdapter adapter = new LoaderAdapter(fragment, (Context)this.getActivity(), (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        Assert.assertTrue((boolean)fragmentCallback.failCalled);
        Assert.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    @Test
    public void testPassModernActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Activity activity = (Activity)Mockito.mock(Activity.class);
        LoaderAdapter adapter = new LoaderAdapter(activity, (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidActivityCallback activityCallback = new VoidActivityCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        Assert.assertTrue((boolean)activityCallback.successCalled);
        Assert.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    @Test
    public void testFailModernActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Activity activity = (Activity)Mockito.mock(Activity.class);
        LoaderAdapter adapter = new LoaderAdapter(activity, (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidActivityCallback activityCallback = new VoidActivityCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        Assert.assertTrue((boolean)activityCallback.failCalled);
        Assert.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    private static class VoidActivityCallback
    extends AbstractActivityCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidActivityCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getActivity());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getActivity());
            this.failCalled = true;
        }
    }

    private static class VoidFragmentCallback
    extends AbstractFragmentCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidFragmentCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getFragment());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getFragment());
            this.failCalled = true;
        }
    }
}

