/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.test.http;

import android.support.test.runner.AndroidJUnit4;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.http.HttpRestProvider;
import org.jboss.aerogear.android.pipe.test.MainActivity;
import org.jboss.aerogear.android.pipe.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.pipe.test.util.UnitTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=AndroidJUnit4.class)
public class HttpRestProviderTest
extends PatchedActivityInstrumentationTestCase {
    private static final URL SIMPLE_URL;
    private static final String HEADER_KEY1_NAME = "KEY1";
    private static final String HEADER_KEY2_NAME = "KEY2";
    private static final byte[] RESPONSE_DATA;
    private static final String REQUEST_DATA = "12345";
    private static final Map<String, List<String>> RESPONSE_HEADERS;
    private static final String HEADER_VALUE = "VALUE";

    public HttpRestProviderTest() {
        super(MainActivity.class);
    }

    @Test
    public void testGetFailsWith404() throws Exception {
        try {
            HttpURLConnection connection404 = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
            ((HttpURLConnection)Mockito.doReturn((Object)404).when((Object)connection404)).getResponseCode();
            Mockito.when((Object)connection404.getErrorStream()).thenReturn((Object)new ByteArrayInputStream(RESPONSE_DATA));
            HttpRestProvider provider = new HttpRestProvider(SIMPLE_URL);
            UnitTestUtils.setPrivateField(provider, "connectionPreparer", new HttpUrlConnectionProvider(connection404));
            try {
                provider.get();
            }
            catch (HttpException exception) {
                for (int i = 0; i < RESPONSE_DATA.length; ++i) {
                    Assert.assertEquals((byte)RESPONSE_DATA[i], (byte)exception.getData()[i]);
                }
                Assert.assertEquals((int)404, (int)exception.getStatusCode());
                throw exception;
            }
        }
        catch (HttpException exception) {
            return;
        }
        Assert.fail((String)"Expected HttpException exception");
    }

    @Test
    public void testGet() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        HttpRestProvider provider = new HttpRestProvider(SIMPLE_URL);
        UnitTestUtils.setPrivateField(provider, "connectionPreparer", new HttpUrlConnectionProvider(connection));
        ((HttpURLConnection)Mockito.doReturn((Object)200).when((Object)connection)).getResponseCode();
        Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream(RESPONSE_DATA));
        Mockito.when(connection.getHeaderFields()).thenReturn(RESPONSE_HEADERS);
        HeaderAndBody result = provider.get();
        for (int i = 0; i < RESPONSE_DATA.length; ++i) {
            Assert.assertEquals((byte)RESPONSE_DATA[i], (byte)result.getBody()[i]);
        }
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY1_NAME));
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY2_NAME));
        Assert.assertEquals((Object)HEADER_VALUE, (Object)result.getHeader(HEADER_KEY2_NAME));
    }

    @Test
    public void testPost() throws Exception {
        int i;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(RESPONSE_DATA.length);
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        HttpRestProvider provider = new HttpRestProvider(SIMPLE_URL);
        UnitTestUtils.setPrivateField(provider, "connectionPreparer", new HttpUrlConnectionProvider(connection));
        ((HttpURLConnection)Mockito.doReturn((Object)200).when((Object)connection)).getResponseCode();
        Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream(RESPONSE_DATA));
        Mockito.when((Object)connection.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when(connection.getHeaderFields()).thenReturn(RESPONSE_HEADERS);
        ((HttpURLConnection)Mockito.doCallRealMethod().when((Object)connection)).setRequestMethod(Matchers.anyString());
        Mockito.when((Object)connection.getRequestMethod()).thenCallRealMethod();
        HeaderAndBody result = provider.post(REQUEST_DATA);
        Assert.assertEquals((String)"POST", (String)connection.getRequestMethod());
        for (i = 0; i < RESPONSE_DATA.length; ++i) {
            Assert.assertEquals((byte)RESPONSE_DATA[i], (byte)result.getBody()[i]);
        }
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY1_NAME));
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY2_NAME));
        Assert.assertEquals((Object)HEADER_VALUE, (Object)result.getHeader(HEADER_KEY2_NAME));
        for (i = 0; i < RESPONSE_DATA.length; ++i) {
            Assert.assertEquals((byte)RESPONSE_DATA[i], (byte)outputStream.toByteArray()[i]);
        }
    }

    @Test
    public void testPut() throws Exception {
        int i;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(RESPONSE_DATA.length);
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        HttpUrlConnectionProvider providerProvider = new HttpUrlConnectionProvider(connection);
        String id2 = "1";
        ((HttpURLConnection)Mockito.doAnswer(new ConnectingAnswer<Integer>(connection, 200)).when((Object)connection)).getResponseCode();
        ((HttpURLConnection)Mockito.doAnswer(new ConnectingAnswer<ByteArrayInputStream>(connection, new ByteArrayInputStream(RESPONSE_DATA))).when((Object)connection)).getInputStream();
        ((HttpURLConnection)Mockito.doAnswer(new ConnectingAnswer<ByteArrayOutputStream>(connection, outputStream)).when((Object)connection)).getOutputStream();
        ((HttpURLConnection)Mockito.doAnswer(new ConnectingAnswer<Map<String, List<String>>>(connection, RESPONSE_HEADERS)).when((Object)connection)).getHeaderFields();
        ((HttpURLConnection)Mockito.doCallRealMethod().when((Object)connection)).setRequestMethod(Matchers.anyString());
        Mockito.when((Object)connection.getRequestMethod()).thenCallRealMethod();
        HttpRestProvider provider = new HttpRestProvider(SIMPLE_URL);
        UnitTestUtils.setPrivateField(provider, "connectionPreparer", providerProvider);
        HeaderAndBody result = provider.put("1", REQUEST_DATA);
        Assert.assertEquals((String)"PUT", (String)connection.getRequestMethod());
        for (i = 0; i < RESPONSE_DATA.length; ++i) {
            Assert.assertEquals((byte)RESPONSE_DATA[i], (byte)result.getBody()[i]);
        }
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY1_NAME));
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY2_NAME));
        Assert.assertEquals((Object)HEADER_VALUE, (Object)result.getHeader(HEADER_KEY2_NAME));
        for (i = 0; i < RESPONSE_DATA.length; ++i) {
            Assert.assertEquals((byte)RESPONSE_DATA[i], (byte)outputStream.toByteArray()[i]);
        }
        Assert.assertEquals((String)"1", (String)providerProvider.id);
    }

    @Test
    public void testDelete() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        HttpUrlConnectionProvider providerProvider = new HttpUrlConnectionProvider(connection);
        String id2 = "1";
        ((HttpURLConnection)Mockito.doReturn((Object)200).when((Object)connection)).getResponseCode();
        Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream(RESPONSE_DATA));
        Mockito.when(connection.getHeaderFields()).thenReturn(RESPONSE_HEADERS);
        ((HttpURLConnection)Mockito.doCallRealMethod().when((Object)connection)).setRequestMethod(Matchers.anyString());
        Mockito.when((Object)connection.getRequestMethod()).thenCallRealMethod();
        HttpRestProvider provider = new HttpRestProvider(SIMPLE_URL);
        UnitTestUtils.setPrivateField(provider, "connectionPreparer", providerProvider);
        HeaderAndBody result = provider.delete("1");
        for (int i = 0; i < RESPONSE_DATA.length; ++i) {
            Assert.assertEquals((byte)RESPONSE_DATA[i], (byte)result.getBody()[i]);
        }
        Assert.assertEquals((String)"DELETE", (String)connection.getRequestMethod());
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY1_NAME));
        Assert.assertNotNull((Object)result.getHeader(HEADER_KEY2_NAME));
        Assert.assertEquals((Object)HEADER_VALUE, (Object)result.getHeader(HEADER_KEY2_NAME));
        Assert.assertEquals((String)"1", (String)providerProvider.id);
    }

    static {
        RESPONSE_DATA = REQUEST_DATA.getBytes();
        try {
            SIMPLE_URL = new URL("http", "localhost", 80, "/");
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HttpRestProviderTest.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        RESPONSE_HEADERS = new HashMap<String, List<String>>(2);
        RESPONSE_HEADERS.put(HEADER_KEY1_NAME, new ArrayList(1));
        RESPONSE_HEADERS.put(HEADER_KEY2_NAME, new ArrayList(1));
        RESPONSE_HEADERS.get(HEADER_KEY1_NAME).add(HEADER_VALUE);
        RESPONSE_HEADERS.get(HEADER_KEY2_NAME).add(HEADER_VALUE);
    }

    private static class ConnectingAnswer<T>
    implements Answer<T> {
        private final HttpURLConnection real;
        private final T i;

        public ConnectingAnswer(HttpURLConnection real, T i) {
            this.real = real;
            this.i = i;
        }

        public T answer(InvocationOnMock invocation) throws Throwable {
            UnitTestUtils.setPrivateField(this.real, "connected", true);
            return this.i;
        }
    }

    static class HttpUrlConnectionProvider
    implements Provider<HttpURLConnection> {
        public HttpURLConnection connection;
        public String id;

        public HttpUrlConnectionProvider(HttpURLConnection connection) {
            this.connection = connection;
        }

        public HttpURLConnection get(Object ... in) {
            if (in != null && in.length > 0) {
                this.id = (String)in[0];
            }
            return this.connection;
        }
    }
}

