/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.http;

import android.test.AndroidTestCase;
import java.util.HashMap;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;

public class HttpHelperTest
extends AndroidTestCase {
    private static final byte[] SIMPLE_DATA = new byte[]{8, 6, 7, 5, 3, 0, 9};
    private static final String SAMPLE_MESSAGE = "SAMPLE_MESSAGE";
    private static final String SAMPLE_HEADER = "SAMPLE_HEADER";
    private static final String DEFAULT_MESSAGE = "The server returned the error code 404.";
    private static final int NOT_FOUND = 404;

    public void testHttpExceptionConstructor() {
        HttpException exception = new HttpException(SIMPLE_DATA, 404);
        HttpException exceptionWithMessage = new HttpException(SIMPLE_DATA, 404, SAMPLE_MESSAGE);
        HttpHelperTest.assertNotSame((Object)SIMPLE_DATA, (Object)exception.getData());
        for (int i = 0; i < SIMPLE_DATA.length; ++i) {
            HttpHelperTest.assertEquals((byte)SIMPLE_DATA[i], (byte)exception.getData()[i]);
        }
        HttpHelperTest.assertEquals((int)404, (int)exception.getStatusCode());
        HttpHelperTest.assertEquals((String)DEFAULT_MESSAGE, (String)exception.getMessage());
        HttpHelperTest.assertEquals((String)SAMPLE_MESSAGE, (String)exceptionWithMessage.getMessage());
    }

    public void testHeaderAndBody() {
        HeaderAndBody headerAndBody = new HeaderAndBody(SIMPLE_DATA, new HashMap());
        headerAndBody.setHeader(SAMPLE_HEADER, (Object)SAMPLE_MESSAGE);
        HttpHelperTest.assertEquals((Object)SAMPLE_MESSAGE, (Object)headerAndBody.getHeader(SAMPLE_HEADER));
    }
}

