/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz.oauth2;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import org.jboss.aerogear.android.authorization.test.MainActivity;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.impl.datamanager.SQLStore;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class AuthzServiceTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private OAuth2AuthzService service;
    private Store mockStore;
    private OAuth2AuthzSession account;
    private URL baseUrl;
    private HttpProvider mockProvider;

    public AuthzServiceTest() {
        super(MainActivity.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mockStore = (Store)Mockito.mock(SQLStore.class);
        this.mockProvider = (HttpProvider)Mockito.mock(HttpProvider.class);
        this.service = new OAuth2AuthzService(){

            protected HttpProvider getHttpProvider(URL url) {
                return AuthzServiceTest.this.mockProvider;
            }
        };
        UnitTestUtils.setPrivateField(this.service, "sessionStore", this.mockStore);
        this.account = new OAuth2AuthzSession();
        this.account.setAccessToken("testToken");
        this.account.setAccountId("testAccountId");
        this.account.setAuthorizationCode(null);
        this.account.setClientId("testClientId");
        this.account.setRefreshToken("testRefreshToken");
        this.baseUrl = new URL("http://example.com");
    }

    public void testFetchTokenReturnsNullForNoAccount() throws OAuth2AuthorizationException {
        AuthzServiceTest.assertEquals(null, (String)this.service.fetchAccessToken("testAccount", new OAuth2Properties(null, null)));
    }

    public void testFetchTokenForFreshAccount() throws OAuth2AuthorizationException {
        this.account.setExpires_on(this.hourFromNow());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        AuthzServiceTest.assertEquals((String)"testToken", (String)this.service.fetchAccessToken("testAccountId", new OAuth2Properties(null, null)));
    }

    public void testErrorJsonMessage() {
        this.account.setExpires_on(this.hourAgo());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        Mockito.when((Object)this.mockProvider.post((byte[])Matchers.any())).thenThrow(new Throwable[]{new HttpException("{\"error\":{\"message\":\"this is a message\"}}".getBytes(), 400)});
        try {
            this.service.fetchAccessToken("testAccountId", new OAuth2Properties(this.baseUrl, null));
        }
        catch (OAuth2AuthorizationException exception) {
            AuthzServiceTest.assertEquals((String)"{\"message\":\"this is a message\"}", (String)exception.error);
            return;
        }
        AuthzServiceTest.fail((String)"Exception not thrown");
    }

    public void testErrorStringMessage() {
        this.account.setExpires_on(this.hourAgo());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        Mockito.when((Object)this.mockProvider.post((byte[])Matchers.any())).thenThrow(new Throwable[]{new HttpException("{\"error\":\"this is a message\"}".getBytes(), 400)});
        try {
            this.service.fetchAccessToken("testAccountId", new OAuth2Properties(this.baseUrl, null));
        }
        catch (OAuth2AuthorizationException exception) {
            AuthzServiceTest.assertEquals((String)"this is a message", (String)exception.error);
            return;
        }
        AuthzServiceTest.fail((String)"Exception not thrown");
    }

    public void testRefreshToken() throws OAuth2AuthorizationException {
        this.account.setExpires_on(this.hourAgo());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        Mockito.when((Object)this.mockProvider.post((byte[])Matchers.any())).thenAnswer((Answer)new Answer<HeaderAndBody>(){

            public HeaderAndBody answer(InvocationOnMock invocation) throws Throwable {
                JsonObject object = new JsonObject();
                object.addProperty("access_token", "testRefreshedAccessToken");
                object.addProperty("expires_in", (Number)3600);
                object.addProperty("refresh_token", "testRefreshToken");
                return new HeaderAndBody(object.toString().getBytes(), new HashMap());
            }
        });
        AuthzServiceTest.assertEquals((String)"testRefreshedAccessToken", (String)this.service.fetchAccessToken("testAccountId", new OAuth2Properties(this.baseUrl, null)));
    }

    private long hourFromNow() {
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.set(10, hourFromNow.get(10) + 1);
        return hourFromNow.getTimeInMillis();
    }

    private long hourAgo() {
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.set(10, hourFromNow.get(10) - 1);
        return hourFromNow.getTimeInMillis();
    }
}

