/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization;

import android.app.Activity;
import android.content.Intent;
import android.content.ServiceConnection;
import android.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authorization.test.MainActivity;
import org.jboss.aerogear.android.impl.authz.AuthorizationManager;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthorizationConfiguration;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzModule;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.impl.util.VoidCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OAuth2AuthzModuleTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private static final URL BASE_URL;

    public OAuth2AuthzModuleTest() {
        super(MainActivity.class);
    }

    public void testRequiresBaseURL() {
        try {
            OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
            OAuth2AuthzModule oAuth2AuthzModule = (OAuth2AuthzModule)config.asModule();
        }
        catch (IllegalStateException ex) {
            return;
        }
        OAuth2AuthzModuleTest.fail((String)"Expecting illegal state exception.");
    }

    public void testCreation() throws MalformedURLException {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        OAuth2AuthzModuleTest.assertFalse((boolean)module.isAuthorized());
        OAuth2AuthzModuleTest.assertEquals((Object)module, (Object)AuthorizationManager.getModule((String)"name"));
    }

    public void testRequestAccess() {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        String state = "testState";
        Activity mockActivity = (Activity)Mockito.mock(Activity.class);
        Callback mockCallback = (Callback)Mockito.mock(Callback.class);
        Mockito.when((Object)mockActivity.bindService((Intent)Matchers.any(Intent.class), (ServiceConnection)Matchers.any(ServiceConnection.class), ((Integer)Matchers.any(Integer.class)).intValue())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockActivity.getApplicationContext()).thenReturn((Object)super.getActivity());
        module.requestAccess(mockActivity, mockCallback);
        ((Activity)Mockito.verify((Object)mockActivity, (VerificationMode)Mockito.times((int)1))).bindService((Intent)Matchers.any(), (ServiceConnection)Matchers.any(), ((Integer)Matchers.any(Integer.class)).intValue());
    }

    public void testGetAccessTokens() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        OAuth2AuthzSession account = new OAuth2AuthzSession();
        account.setAccessToken("testToken");
        UnitTestUtils.setPrivateField(module, "account", account);
        OAuth2AuthzModuleTest.assertEquals((String)"Bearer testToken", (String)((String)((Pair)module.getAuthorizationFields(null, null, null).getHeaders().get((int)0)).second));
        OAuth2AuthzModuleTest.assertEquals((String)"Authorization", (String)((String)((Pair)module.getAuthorizationFields(null, null, null).getHeaders().get((int)0)).first));
    }

    public void testOAuth2AuthorizationCallback() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException, OAuth2AuthorizationException, InterruptedException {
        OAuth2AuthzService mockService = (OAuth2AuthzService)Mockito.mock(OAuth2AuthzService.class);
        Activity mockActivity = (Activity)Mockito.mock(Activity.class);
        ServiceConnection mockServiceConnection = (ServiceConnection)Mockito.mock(ServiceConnection.class);
        ArgumentCaptor sessionCaptor = ArgumentCaptor.forClass(OAuth2AuthzSession.class);
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setAccountId("testAccountId");
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        Class<?> callbackClass = Class.forName("org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzModule$OAuth2AuthorizationCallback");
        Constructor<?> constructor = callbackClass.getDeclaredConstructor(OAuth2AuthzModule.class, Activity.class, Callback.class, ServiceConnection.class);
        constructor.setAccessible(true);
        Callback callback = (Callback)constructor.newInstance(module, mockActivity, new VoidCallback(), mockServiceConnection);
        UnitTestUtils.setPrivateField(module, "service", mockService);
        callback.onSuccess((Object)"testCode");
        ((OAuth2AuthzService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).addAccount((OAuth2AuthzSession)sessionCaptor.capture());
        OAuth2AuthzSession account = (OAuth2AuthzSession)sessionCaptor.getValue();
        OAuth2AuthzModuleTest.assertEquals((String)"testCode", (String)account.getAuthorizationCode());
    }

    public void testOAuth2AccessCallback() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        OAuth2AuthzService mockService = (OAuth2AuthzService)Mockito.mock(OAuth2AuthzService.class);
        Activity mockActivity = (Activity)Mockito.mock(Activity.class);
        ServiceConnection mockServiceConnection = (ServiceConnection)Mockito.mock(ServiceConnection.class);
        OAuth2AuthzSession account = new OAuth2AuthzSession();
        account.setAccessToken("testToken");
        Mockito.when((Object)mockService.getAccount(Matchers.matches((String)"testAccountId"))).thenReturn((Object)account);
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setAccountId("testAccountId");
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        Class<?> callbackClass = Class.forName("org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzModule$OAuth2AccessCallback");
        Constructor<?> constructor = callbackClass.getDeclaredConstructor(OAuth2AuthzModule.class, Activity.class, Callback.class, ServiceConnection.class);
        constructor.setAccessible(true);
        Callback callback = (Callback)constructor.newInstance(module, mockActivity, new VoidCallback(), mockServiceConnection);
        UnitTestUtils.setPrivateField(module, "service", mockService);
        callback.onSuccess((Object)"testToken");
        ((Activity)Mockito.verify((Object)mockActivity, (VerificationMode)Mockito.times((int)1))).unbindService((ServiceConnection)Matchers.eq((Object)mockServiceConnection));
        OAuth2AuthzModuleTest.assertEquals((String)"testToken", (String)UnitTestUtils.getPrivateField(module, "account", OAuth2AuthzSession.class).getAccessToken());
    }

    static {
        try {
            BASE_URL = new URL("https://example.com");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

